/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.util.function.BiFunction;
import smile.classification.Classifier;
import smile.classification.DataFrameClassifier;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.regression.DataFrameRegression;
import smile.regression.Regression;

public class CrossValidation {
    public final int k;
    public final int[][] train;
    public final int[][] test;

    public CrossValidation(int n, int k) {
        this(n, k, true);
    }

    public CrossValidation(int n, int k, boolean permutate) {
        int[] index;
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sample size: " + n);
        }
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("Invalid number of CV rounds: " + k);
        }
        this.k = k;
        if (permutate) {
            index = MathEx.permutate((int)n);
        } else {
            index = new int[n];
            for (int i = 0; i < n; ++i) {
                index[i] = i;
            }
        }
        this.train = new int[k][];
        this.test = new int[k][];
        int chunk = n / k;
        for (int i = 0; i < k; ++i) {
            int start = chunk * i;
            int end = chunk * (i + 1);
            if (i == k - 1) {
                end = n;
            }
            this.train[i] = new int[n - end + start];
            this.test[i] = new int[end - start];
            int p = 0;
            int q = 0;
            for (int j = 0; j < n; ++j) {
                if (j >= start && j < end) {
                    this.test[i][p++] = index[j];
                    continue;
                }
                this.train[i][q++] = index[j];
            }
        }
    }

    public <T> int[] classification(T[] x, int[] y, BiFunction<T[], int[], Classifier<T>> trainer) {
        int[] prediction = new int[x.length];
        for (int i = 0; i < this.k; ++i) {
            Object[] trainx = MathEx.slice((Object[])x, (int[])this.train[i]);
            int[] trainy = MathEx.slice((int[])y, (int[])this.train[i]);
            Classifier<T> model = trainer.apply((Object[][])trainx, trainy);
            for (int j : this.test[i]) {
                prediction[j] = model.predict(x[j]);
            }
        }
        return prediction;
    }

    public int[] classification(Formula formula, DataFrame data, BiFunction<Formula, DataFrame, DataFrameClassifier> trainer) {
        int[] prediction = new int[data.size()];
        for (int i = 0; i < this.k; ++i) {
            DataFrameClassifier model = trainer.apply(formula, data.of(this.train[i]));
            for (int j : this.test[i]) {
                prediction[j] = model.predict((Tuple)data.get(j));
            }
        }
        return prediction;
    }

    public <T> double[] regression(T[] x, double[] y, BiFunction<T[], double[], Regression<T>> trainer) {
        double[] prediction = new double[x.length];
        for (int i = 0; i < this.k; ++i) {
            Object[] trainx = MathEx.slice((Object[])x, (int[])this.train[i]);
            double[] trainy = MathEx.slice((double[])y, (int[])this.train[i]);
            Regression<T> model = trainer.apply((Object[][])trainx, trainy);
            for (int j : this.test[i]) {
                prediction[j] = model.predict(x[j]);
            }
        }
        return prediction;
    }

    public double[] regression(Formula formula, DataFrame data, BiFunction<Formula, DataFrame, DataFrameRegression> trainer) {
        double[] prediction = new double[data.size()];
        for (int i = 0; i < this.k; ++i) {
            DataFrameRegression model = trainer.apply(formula, data.of(this.train[i]));
            for (int j : this.test[i]) {
                prediction[j] = model.predict((Tuple)data.get(j));
            }
        }
        return prediction;
    }

    public static <T> int[] classification(int k, T[] x, int[] y, BiFunction<T[], int[], Classifier<T>> trainer) {
        CrossValidation cv = new CrossValidation(x.length, k);
        return cv.classification(x, y, trainer);
    }

    public static int[] classification(int k, Formula formula, DataFrame data, BiFunction<Formula, DataFrame, DataFrameClassifier> trainer) {
        CrossValidation cv = new CrossValidation(data.size(), k);
        return cv.classification(formula, data, trainer);
    }

    public static <T> double[] regression(int k, T[] x, double[] y, BiFunction<T[], double[], Regression<T>> trainer) {
        CrossValidation cv = new CrossValidation(x.length, k);
        return cv.regression(x, y, trainer);
    }

    public static double[] regression(int k, Formula formula, DataFrame data, BiFunction<Formula, DataFrame, DataFrameRegression> trainer) {
        CrossValidation cv = new CrossValidation(data.size(), k);
        return cv.regression(formula, data, trainer);
    }
}

