/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.MathEx;

class ContingencyTable {
    public final int n;
    public final int n1;
    public final int n2;
    public final int[] a;
    public final int[] b;
    public final int[][] table;

    public ContingencyTable(int[] y1, int[] y2) {
        int j;
        int i;
        if (y1.length != y2.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", y1.length, y2.length));
        }
        this.n = y1.length;
        int[] label1 = MathEx.unique((int[])y1);
        this.n1 = label1.length;
        int[] label2 = MathEx.unique((int[])y2);
        this.n2 = label2.length;
        this.table = new int[this.n1][this.n2];
        for (i = 0; i < this.n1; ++i) {
            for (j = 0; j < this.n2; ++j) {
                int nij = 0;
                for (int k = 0; k < this.n; ++k) {
                    if (y1[k] != label1[i] || y2[k] != label2[j]) continue;
                    ++nij;
                }
                this.table[i][j] = nij;
            }
        }
        this.a = new int[this.n1];
        this.b = new int[this.n2];
        for (i = 0; i < this.n1; ++i) {
            for (j = 0; j < this.n2; ++j) {
                int n = i;
                this.a[n] = this.a[n] + this.table[i][j];
                int n2 = j;
                this.b[n2] = this.b[n2] + this.table[i][j];
            }
        }
    }
}

