/*
 * Decompiled with CFR 0.152.
 */
package smile.sampling;

import java.util.Arrays;
import java.util.stream.Collectors;
import smile.classification.ClassLabels;
import smile.math.MathEx;

public class Bagging {
    public final int[] samples;

    public Bagging(int[] samples) {
        this.samples = samples;
    }

    public String toString() {
        return Arrays.stream(this.samples).mapToObj(String::valueOf).collect(Collectors.joining(", ", "Bagging(", ")"));
    }

    public static Bagging random(int n, double subsample) {
        if (subsample == 1.0) {
            int[] samples = new int[n];
            for (int i = 0; i < n; ++i) {
                samples[i] = MathEx.randomInt((int)n);
            }
            return new Bagging(samples);
        }
        int size = (int)Math.round(subsample * (double)n);
        int[] samples = MathEx.permutate((int)n);
        return new Bagging(Arrays.copyOf(samples, size));
    }

    public static Bagging strateify(int[] strata, double subsample) {
        ClassLabels codec = ClassLabels.fit(strata);
        int k = codec.k;
        int[] y = codec.y;
        int n = y.length;
        int[] count = new int[k];
        for (int i = 0; i < n; ++i) {
            int n2 = y[i];
            count[n2] = count[n2] + 1;
        }
        int[][] yi = new int[k][];
        for (int i = 0; i < k; ++i) {
            yi[i] = new int[count[i]];
        }
        int[] idx = new int[k];
        int i = 0;
        while (i < n) {
            int j;
            int n3 = j = y[i];
            int n4 = idx[n3];
            idx[n3] = n4 + 1;
            yi[j][n4] = i++;
        }
        if (subsample == 1.0) {
            int[] samples = new int[n];
            int l = 0;
            for (int i2 = 0; i2 < k; ++i2) {
                int ni = count[i2];
                int[] yj = yi[i2];
                for (int j = 0; j < ni; ++j) {
                    samples[l++] = yj[MathEx.randomInt((int)ni)];
                }
            }
            return new Bagging(samples);
        }
        int size = 0;
        for (int i3 = 0; i3 < k; ++i3) {
            size += (int)Math.round(subsample * (double)count[i3]);
        }
        int[] samples = new int[size];
        int l = 0;
        for (int i4 = 0; i4 < k; ++i4) {
            int ni = (int)Math.round(subsample * (double)count[i4]);
            int[] yj = yi[i4];
            int[] permutation = MathEx.permutate((int)count[i4]);
            for (int j = 0; j < ni; ++j) {
                samples[l++] = yj[permutation[j]];
            }
        }
        return new Bagging(samples);
    }
}

