/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import smile.math.blas.UPLO;
import smile.math.kernel.MercerKernel;
import smile.math.matrix.Matrix;
import smile.regression.KernelMachine;

public class GaussianProcessRegression {
    public static <T> KernelMachine<T> fit(T[] x, double[] y, MercerKernel<T> kernel, double lambda) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        Matrix K = new Matrix(n, n);
        K.uplo(UPLO.LOWER);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double k = kernel.k(x[i], x[j]);
                K.set(i, j, k);
                K.set(j, i, k);
            }
            K.add(i, i, lambda);
        }
        Matrix.Cholesky cholesky = K.cholesky(true);
        double[] w = cholesky.solve(y);
        return new KernelMachine<T>(kernel, x, w);
    }

    public static <T> KernelMachine<T> fit(T[] x, double[] y, T[] t, MercerKernel<T> kernel, double lambda) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        int m = t.length;
        Matrix G = new Matrix(n, m);
        for (int j = 0; j < m; ++j) {
            for (i = 0; i < n; ++i) {
                G.set(i, j, kernel.k(x[i], t[j]));
            }
        }
        Matrix K = G.ata();
        for (i = 0; i < m; ++i) {
            for (int j = 0; j <= i; ++j) {
                K.add(i, j, lambda * kernel.k(t[i], t[j]));
                K.set(j, i, K.get(i, j));
            }
        }
        double[] Gty = G.tv(y);
        Matrix.LU lu = K.lu(true);
        double[] w = lu.solve(Gty);
        return new KernelMachine<T>(kernel, t, w);
    }

    public static <T> KernelMachine<T> nystrom(T[] x, double[] y, T[] t, MercerKernel<T> kernel, double lambda) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        int m = t.length;
        Matrix E = new Matrix(n, m);
        for (int j = 0; j < m; ++j) {
            for (i = 0; i < n; ++i) {
                E.set(i, j, kernel.k(x[i], t[j]));
            }
        }
        Matrix W = new Matrix(m, m);
        for (i = 0; i < m; ++i) {
            for (int j = 0; j <= i; ++j) {
                double k = kernel.k(t[i], t[j]);
                W.set(i, j, k);
                W.set(j, i, k);
            }
        }
        W.uplo(UPLO.LOWER);
        Matrix.EVD eigen = W.eigen(false, true, true).sort();
        Matrix U = eigen.Vr;
        Matrix D = eigen.diag();
        for (int i2 = 0; i2 < m; ++i2) {
            D.set(i2, i2, 1.0 / Math.sqrt(D.get(i2, i2)));
        }
        Matrix UD = U.mm(D);
        Matrix UDUt = UD.mt(U);
        Matrix L = E.mm(UDUt);
        Matrix LtL = L.ata();
        for (int i3 = 0; i3 < m; ++i3) {
            LtL.add(i3, i3, lambda);
        }
        Matrix.Cholesky chol = LtL.cholesky(true);
        Matrix invLtL = chol.inverse();
        Matrix K = L.mm(invLtL).mt(L);
        double[] w = K.tv(y);
        for (int i4 = 0; i4 < n; ++i4) {
            w[i4] = (y[i4] - w[i4]) / lambda;
        }
        return new KernelMachine<T>(kernel, x, w);
    }
}

