/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import java.util.Arrays;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.kernel.MercerKernel;
import smile.math.matrix.ARPACK;
import smile.math.matrix.DMatrix;
import smile.math.matrix.Matrix;
import smile.projection.Projection;

public class KPCA<T>
implements Projection<T>,
Serializable {
    private static final long serialVersionUID = 2L;
    private int p;
    private T[] data;
    private MercerKernel<T> kernel;
    private double[] mean;
    private double mu;
    private double[] latent;
    private Matrix projection;
    private double[][] coordinates;

    public KPCA(T[] data, MercerKernel<T> kernel, double[] mean, double mu, double[][] coordinates, double[] latent, Matrix projection) {
        this.data = data;
        this.kernel = kernel;
        this.mean = mean;
        this.mu = mu;
        this.coordinates = coordinates;
        this.latent = latent;
        this.projection = projection;
        this.p = projection.nrows();
    }

    public static <T> KPCA<T> fit(T[] data, MercerKernel<T> kernel, int k) {
        return KPCA.fit(data, kernel, k, 1.0E-4);
    }

    public static <T> KPCA<T> fit(T[] data, MercerKernel<T> kernel, int k, double threshold) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Invalid threshold = " + threshold);
        }
        if (k < 1 || k > data.length) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + k);
        }
        int n = data.length;
        Matrix K = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = kernel.k(data[i], data[j]);
                K.set(i, j, x);
                K.set(j, i, x);
            }
        }
        double[] mean = K.rowMeans();
        double mu = MathEx.mean((double[])mean);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = K.get(i, j) - mean[i] - mean[j] + mu;
                K.set(i, j, x);
                K.set(j, i, x);
            }
        }
        K.uplo(UPLO.LOWER);
        Matrix.EVD eigen = ARPACK.syev((DMatrix)K, (ARPACK.SymmOption)ARPACK.SymmOption.LA, (int)k);
        double[] eigvalues = eigen.wr;
        Matrix eigvectors = eigen.Vr;
        int p = (int)Arrays.stream(eigvalues).limit(k).filter(e -> e / (double)n > threshold).count();
        double[] latent = new double[p];
        Matrix projection = new Matrix(p, n);
        for (int j = 0; j < p; ++j) {
            latent[j] = eigvalues[j];
            double s = Math.sqrt(latent[j]);
            for (int i = 0; i < n; ++i) {
                projection.set(j, i, eigvectors.get(i, j) / s);
            }
        }
        Matrix coord = projection.mm(K);
        double[][] coordinates = new double[n][p];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                coordinates[i][j] = coord.get(j, i);
            }
        }
        return new KPCA<T>(data, kernel, mean, mu, coordinates, latent, projection);
    }

    public double[] getVariances() {
        return this.latent;
    }

    public Matrix getProjection() {
        return this.projection;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public double[] project(T x) {
        int n = this.data.length;
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            y[i] = this.kernel.k(x, this.data[i]);
        }
        double my = MathEx.mean((double[])y);
        for (int i = 0; i < n; ++i) {
            y[i] = y[i] - my - this.mean[i] + this.mu;
        }
        return this.projection.mv(y);
    }

    @Override
    public double[][] project(T[] x) {
        int m = x.length;
        int n = this.data.length;
        double[][] y = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                y[i][j] = this.kernel.k(x[i], this.data[j]);
            }
            double my = MathEx.mean((double[])y[i]);
            for (int j = 0; j < n; ++j) {
                y[i][j] = y[i][j] - my - this.mean[j] + this.mu;
            }
        }
        double[][] z = new double[x.length][this.p];
        for (int i = 0; i < y.length; ++i) {
            this.projection.mv(y[i], z[i]);
        }
        return z;
    }
}

