/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.util.List;
import java.util.stream.Collectors;
import smile.neighbor.LSH;
import smile.neighbor.lsh.Bucket;
import smile.neighbor.lsh.Hash;

public class MutableLSH<E>
extends LSH<E> {
    public MutableLSH(int d, int L, int k, double w) {
        super(d, L, k, w, 1017881);
    }

    @Override
    public void put(double[] key, E value) {
        int index = this.keys.size();
        for (int i = 0; i < index; ++i) {
            if (this.keys.get(i) != null) continue;
            index = i;
            this.keys.set(i, key);
            this.data.set(i, value);
            break;
        }
        if (index == this.keys.size()) {
            this.keys.add(key);
            this.data.add(value);
        }
        for (Hash h : this.hash) {
            h.add(index, key);
        }
    }

    public void remove(double[] key, E value) {
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            if (this.data.get(i) != value) continue;
            this.keys.set(i, null);
            this.data.set(i, null);
            for (Hash h : this.hash) {
                Bucket bucket = h.get(key);
                if (bucket == null) {
                    System.out.println("impossible");
                }
                bucket.remove(i);
            }
            return;
        }
        throw new IllegalArgumentException("Remove non-exist element");
    }

    public void update(double[] key, E value) {
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            if (this.data.get(i) != value) continue;
            double[] oldKey = (double[])this.keys.get(i);
            this.keys.set(i, key);
            for (Hash h : this.hash) {
                int oldBucket = h.hash(oldKey);
                int newBucket = h.hash(key);
                if (newBucket == oldBucket) continue;
                h.get(oldBucket).remove(i);
                h.get(newBucket).add(i);
            }
            return;
        }
        throw new IllegalArgumentException("Update non-exist element");
    }

    public List<double[]> keys() {
        return this.keys.stream().filter(key -> key != null).collect(Collectors.toList());
    }

    public List<E> values() {
        return this.data.stream().filter(value -> value != null).collect(Collectors.toList());
    }
}

