/*
 * Decompiled with CFR 0.152.
 */
package smile.glm.model;

import java.util.stream.IntStream;
import smile.glm.model.Model;

public interface Bernoulli {
    public static Model logit() {
        return new Model(){

            public String toString() {
                return "Bernoulli(logit)";
            }

            @Override
            public double link(double mu) {
                return Math.log(mu / (1.0 - mu));
            }

            @Override
            public double invlink(double eta) {
                return 1.0 / (1.0 + Math.exp(-eta));
            }

            @Override
            public double dlink(double mu) {
                return 1.0 / (mu * (1.0 - mu));
            }

            @Override
            public double variance(double mu) {
                return mu * (1.0 - mu);
            }

            @Override
            public double mustart(double y) {
                if (y == 0.0) {
                    return 0.1;
                }
                if (y == 1.0) {
                    return 0.9;
                }
                throw new IllegalArgumentException("Invalid argument (expected 0 or 1): " + y);
            }

            @Override
            public double deviance(double[] y, double[] mu, double[] residuals) {
                return IntStream.range(0, y.length).mapToDouble(i -> {
                    double d = -2.0 * (y[i] == 0.0 ? Math.log(1.0 - mu[i]) : Math.log(mu[i]));
                    residuals[i] = Math.sqrt(d) * Math.signum(y[i] - mu[i]);
                    return d;
                }).sum();
            }

            @Override
            public double nullDeviance(double[] y, double mu) {
                double logmu = -Math.log(mu);
                double logmu1 = -Math.log(1.0 - mu);
                return 2.0 * IntStream.range(0, y.length).mapToDouble(i -> y[i] == 0.0 ? logmu1 : logmu).sum();
            }

            @Override
            public double loglikelihood(double[] y, double[] mu) {
                return IntStream.range(0, y.length).mapToDouble(i -> y[i] == 0.0 ? Math.log(1.0 - mu[i]) : Math.log(mu[i])).sum();
            }
        };
    }
}

