/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;
import smile.math.distance.Distance;

public class WPGMCLinkage
extends Linkage {
    public WPGMCLinkage(double[][] proximity) {
        super(proximity);
        this.init();
    }

    public WPGMCLinkage(int size, float[] proximity) {
        super(size, proximity);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.proximity.length; ++i) {
            int n = i;
            this.proximity[n] = this.proximity[n] * this.proximity[i];
        }
    }

    public static WPGMCLinkage of(double[][] data) {
        return new WPGMCLinkage(data.length, WPGMCLinkage.proximity(data));
    }

    public static <T> WPGMCLinkage of(T[] data, Distance<T> distance) {
        return new WPGMCLinkage(data.length, WPGMCLinkage.proximity(data, distance));
    }

    public String toString() {
        return "WPGMC linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        for (k = 0; k < i; ++k) {
            this.proximity[this.index((int)i, (int)k)] = (this.d(i, k) + this.d(j, k)) / 2.0f - this.d(j, i) / 4.0f;
        }
        for (k = i + 1; k < j; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) + this.d(j, k)) / 2.0f - this.d(j, i) / 4.0f;
        }
        for (k = j + 1; k < this.size; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) + this.d(k, j)) / 2.0f - this.d(j, i) / 4.0f;
        }
    }
}

