/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;
import smile.math.distance.Distance;

public class UPGMCLinkage
extends Linkage {
    private int[] n;

    public UPGMCLinkage(double[][] proximity) {
        super(proximity);
        this.init();
    }

    public UPGMCLinkage(int size, float[] proximity) {
        super(size, proximity);
        this.init();
    }

    private void init() {
        int i;
        this.n = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            this.n[i] = 1;
        }
        for (i = 0; i < this.proximity.length; ++i) {
            int n = i;
            this.proximity[n] = this.proximity[n] * this.proximity[i];
        }
    }

    public static UPGMCLinkage of(double[][] data) {
        return new UPGMCLinkage(data.length, UPGMCLinkage.proximity(data));
    }

    public static <T> UPGMCLinkage of(T[] data, Distance<T> distance) {
        return new UPGMCLinkage(data.length, UPGMCLinkage.proximity(data, distance));
    }

    public String toString() {
        return "UPGMC linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        float nij = this.n[i] + this.n[j];
        for (k = 0; k < i; ++k) {
            this.proximity[this.index((int)i, (int)k)] = (this.d(i, k) * (float)this.n[i] + this.d(j, k) * (float)this.n[j] - this.d(j, i) * (float)this.n[i] * (float)this.n[j] / nij) / nij;
        }
        for (k = i + 1; k < j; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) * (float)this.n[i] + this.d(j, k) * (float)this.n[j] - this.d(j, i) * (float)this.n[i] * (float)this.n[j] / nij) / nij;
        }
        for (k = j + 1; k < this.size; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) * (float)this.n[i] + this.d(k, j) * (float)this.n[j] - this.d(j, i) * (float)this.n[i] * (float)this.n[j] / nij) / nij;
        }
        int n = i;
        this.n[n] = this.n[n] + this.n[j];
    }
}

