/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;
import smile.math.distance.Distance;

public class SingleLinkage
extends Linkage {
    public SingleLinkage(double[][] proximity) {
        super(proximity);
    }

    public SingleLinkage(int size, float[] proximity) {
        super(size, proximity);
    }

    public static SingleLinkage of(double[][] data) {
        return new SingleLinkage(data.length, SingleLinkage.proximity(data));
    }

    public static <T> SingleLinkage of(T[] data, Distance<T> distance) {
        return new SingleLinkage(data.length, SingleLinkage.proximity(data, distance));
    }

    public String toString() {
        return "single linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        for (k = 0; k < i; ++k) {
            this.proximity[this.index((int)i, (int)k)] = Math.min(this.d(i, k), this.d(j, k));
        }
        for (k = i + 1; k < this.size; ++k) {
            this.proximity[this.index((int)k, (int)i)] = Math.min(this.d(k, i), this.d(j, k));
        }
    }
}

