/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.IntStream;
import smile.math.MathEx;

public abstract class PartitionClustering
implements Serializable {
    public static final int OUTLIER = Integer.MAX_VALUE;
    public final int k;
    public final int[] y;
    public final int[] size;

    public PartitionClustering(int k, int[] y) {
        this.k = k;
        this.y = y;
        this.size = new int[k + 1];
        for (int yi : y) {
            if (yi == Integer.MAX_VALUE) {
                int n = k;
                this.size[n] = this.size[n] + 1;
                continue;
            }
            int n = yi;
            this.size[n] = this.size[n] + 1;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Cluster size of %d data points:%n", this.y.length));
        for (int i = 0; i < this.k; ++i) {
            double r = 100.0 * (double)this.size[i] / (double)this.y.length;
            sb.append(String.format("Cluster %4d %6d (%4.1f%%)%n", i + 1, this.size[i], r));
        }
        if (this.size[this.k] != 0) {
            double r = 100.0 * (double)this.size[this.k] / (double)this.y.length;
            sb.append(String.format("Outliers     %6d (%4.1f%%)%n", this.size[this.k], r));
        }
        return sb.toString();
    }

    public static <T> double[] seed(T[] data, T[] medoids, int[] y, ToDoubleBiFunction<T, T> distance) {
        int n = data.length;
        int k = medoids.length;
        double[] d = new double[n];
        medoids[0] = data[MathEx.randomInt((int)n)];
        Arrays.fill(d, Double.MAX_VALUE);
        block0: for (int j = 1; j <= k; ++j) {
            int prev = j - 1;
            Object medoid = medoids[prev];
            IntStream.range(0, n).parallel().forEach(i -> {
                double dist = distance.applyAsDouble(data[i], medoid);
                if (dist < d[i]) {
                    d[i] = dist;
                    y[i] = prev;
                }
            });
            if (j >= k) continue;
            double cost = 0.0;
            double cutoff = MathEx.random() * MathEx.sum((double[])d);
            for (int index = 0; index < n; ++index) {
                if (!((cost += d[index]) >= cutoff)) continue;
                medoids[j] = data[index];
                continue block0;
            }
        }
        return d;
    }

    public static <T extends PartitionClustering> T run(int runs, Supplier<T> clustering) {
        if (runs <= 0) {
            throw new IllegalArgumentException("Invalid number of runs: " + runs);
        }
        return (T)IntStream.range(0, runs).mapToObj(run -> (PartitionClustering)clustering.get()).min(Comparator.naturalOrder()).get();
    }
}

