/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import smile.base.svm.KernelMachine;
import smile.base.svm.LASVM;
import smile.base.svm.LinearKernelMachine;
import smile.classification.Classifier;
import smile.math.kernel.BinarySparseLinearKernel;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.MercerKernel;
import smile.math.kernel.SparseLinearKernel;
import smile.util.SparseArray;

public class SVM<T>
extends KernelMachine<T>
implements Classifier<T> {
    public SVM(MercerKernel<T> kernel, T[] instances, double[] weight, double b) {
        super(kernel, instances, weight, b);
    }

    @Override
    public int predict(T x) {
        return this.f(x) > 0.0 ? 1 : -1;
    }

    public static Classifier<double[]> fit(double[][] x, int[] y, double C, double tol) {
        LASVM lasvm = new LASVM(new LinearKernel(), C, tol);
        final KernelMachine svm = lasvm.fit((T[])x, y);
        return new Classifier<double[]>(){
            LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.of(svm);
            }

            @Override
            public int predict(double[] x) {
                return this.model.f(x) > 0.0 ? 1 : -1;
            }
        };
    }

    public static Classifier<int[]> fit(int[][] x, int[] y, final int p, double C, double tol) {
        LASVM lasvm = new LASVM(new BinarySparseLinearKernel(), C, tol);
        final KernelMachine svm = lasvm.fit((T[])x, y);
        return new Classifier<int[]>(){
            LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.binary(p, svm);
            }

            @Override
            public int predict(int[] x) {
                return this.model.f(x) > 0.0 ? 1 : -1;
            }
        };
    }

    public static Classifier<SparseArray> fit(SparseArray[] x, int[] y, final int p, double C, double tol) {
        LASVM<SparseArray> lasvm = new LASVM<SparseArray>((MercerKernel<SparseArray>)new SparseLinearKernel(), C, tol);
        final KernelMachine<SparseArray> svm = lasvm.fit(x, y);
        return new Classifier<SparseArray>(){
            LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.sparse(p, svm);
            }

            @Override
            public int predict(SparseArray x) {
                return this.model.f(x) > 0.0 ? 1 : -1;
            }
        };
    }

    public static <T> SVM<T> fit(T[] x, int[] y, MercerKernel<T> kernel, double C, double tol) {
        LASVM<T> lasvm = new LASVM<T>(kernel, C, tol);
        return lasvm.fit(x, y).toSVM();
    }
}

