/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.util.function.BiFunction;
import smile.classification.ClassLabels;
import smile.classification.Classifier;
import smile.classification.PlattScaling;
import smile.classification.SoftClassifier;
import smile.math.MathEx;
import smile.util.IntSet;

public class OneVersusRest<T>
implements SoftClassifier<T> {
    private static final long serialVersionUID = 2L;
    private int k;
    private Classifier<T>[] classifiers;
    private PlattScaling[] platts;
    private IntSet labels;

    public OneVersusRest(Classifier<T>[] classifiers, PlattScaling[] platts) {
        this.classifiers = classifiers;
        this.platts = platts;
        this.k = classifiers.length;
        this.labels = IntSet.of((int)this.k);
    }

    public OneVersusRest(Classifier<T>[] classifiers, PlattScaling[] platts, IntSet labels) {
        this.classifiers = classifiers;
        this.platts = platts;
        this.k = classifiers.length;
        this.labels = labels;
    }

    public static <T> OneVersusRest<T> fit(T[] x, int[] y, BiFunction<T[], int[], Classifier<T>> trainer) {
        return OneVersusRest.fit(x, y, 1, -1, trainer);
    }

    public static <T> OneVersusRest<T> fit(T[] x, int[] y, int pos, int neg, BiFunction<T[], int[], Classifier<T>> trainer) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        ClassLabels codec = ClassLabels.fit(y);
        int k = codec.k;
        if (k <= 2) {
            throw new IllegalArgumentException(String.format("Only %d classes" + k, new Object[0]));
        }
        int n = x.length;
        y = codec.y;
        Classifier[] classifiers = new Classifier[k];
        PlattScaling[] platts = new PlattScaling[k];
        for (int i = 0; i < k; ++i) {
            int[] yi = new int[n];
            for (int j = 0; j < n; ++j) {
                yi[j] = y[j] == i ? pos : neg;
            }
            classifiers[i] = trainer.apply((T[][])x, yi);
            platts[i] = PlattScaling.fit(classifiers[i], x, yi);
        }
        return new OneVersusRest<T>(classifiers, platts);
    }

    @Override
    public int predict(T x) {
        int y = 0;
        double maxf = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.k; ++i) {
            double f = this.platts[i].scale(this.classifiers[i].f(x));
            if (!(f > maxf)) continue;
            y = i;
            maxf = f;
        }
        return this.labels.valueOf(y);
    }

    @Override
    public int predict(T x, double[] posteriori) {
        for (int i = 0; i < this.k; ++i) {
            posteriori[i] = this.platts[i].scale(this.classifiers[i].f(x));
        }
        MathEx.unitize1((double[])posteriori);
        return this.labels.valueOf(MathEx.whichMax((double[])posteriori));
    }
}

