/*
 * Decompiled with CFR 0.152.
 */
package smile.base.cart;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import smile.base.cart.InternalNode;
import smile.base.cart.LeafNode;
import smile.base.cart.Node;

public abstract class Split {
    public static Comparator<Split> comparator = (x, y) -> Double.compare(x.score, y.score);
    final LeafNode leaf;
    final int feature;
    final double score;
    final int lo;
    final int hi;
    final int trueCount;
    final int falseCount;
    InternalNode parent;
    boolean[] unsplittable;
    int depth = 1;

    public Split(LeafNode leaf, int feature, double score, int lo, int hi, int trueCount, int falseCount) {
        this.leaf = leaf;
        this.feature = feature;
        this.score = score;
        this.lo = lo;
        this.hi = hi;
        this.trueCount = trueCount;
        this.falseCount = falseCount;
    }

    public abstract InternalNode toNode(Node var1, Node var2);

    public abstract IntPredicate predicate();

    public String toString() {
        String[] fields = new String[]{"feature: " + this.feature, "score: " + this.score, "lo: " + this.lo, "hi: " + this.hi, "true: " + this.trueCount, "false: " + this.falseCount, "depth: " + this.depth};
        return Arrays.stream(fields).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }
}

