/*
 * Decompiled with CFR 0.152.
 */
package smile.base.cart;

import smile.base.cart.InternalNode;
import smile.base.cart.LeafNode;
import smile.base.cart.Node;
import smile.data.Tuple;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class OrdinalNode
extends InternalNode {
    private static final long serialVersionUID = 2L;
    double value;

    public OrdinalNode(int feature, double value, double score, double deviance, Node trueChild, Node falseChild) {
        super(feature, score, deviance, trueChild, falseChild);
        this.value = value;
    }

    @Override
    public LeafNode predict(Tuple x) {
        return x.getDouble(this.feature) <= this.value ? this.trueChild.predict(x) : this.falseChild.predict(x);
    }

    @Override
    public boolean branch(Tuple x) {
        return x.getDouble(this.feature) <= this.value;
    }

    @Override
    public OrdinalNode replace(Node trueChild, Node falseChild) {
        return new OrdinalNode(this.feature, this.value, this.score, this.deviance, trueChild, falseChild);
    }

    @Override
    public String dot(StructType schema, StructField response, int id) {
        StructField field = schema.field(this.feature);
        return String.format(" %d [label=<%s &le; %s<br/>size = %d<br/>impurity reduction = %.4f>, fillcolor=\"#00000000\"];\n", id, field.name, field.toString((Object)this.value), this.size(), this.score);
    }

    @Override
    public String toString(StructType schema, boolean trueBranch) {
        StructField field = schema.field(this.feature);
        String condition = trueBranch ? "<=" : ">";
        return String.format("%s%s%g", field.name, condition, this.value);
    }
}

