/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import smile.util.Strings;

public class Neighbor<K, V>
implements Comparable<Neighbor<K, V>> {
    public final K key;
    public final V value;
    public final int index;
    public final double distance;

    public Neighbor(K key, V object, int index, double distance) {
        this.key = key;
        this.value = object;
        this.index = index;
        this.distance = distance;
    }

    @Override
    public int compareTo(Neighbor<K, V> o) {
        int d = Double.compare(this.distance, o.distance);
        return d == 0 ? Integer.compare(this.index, o.index) : d;
    }

    public String toString() {
        return String.format("%s(%d):%s", this.key, this.index, Strings.format(this.distance));
    }

    public static <T> Neighbor<T, T> of(T key, int index, double distance) {
        return new Neighbor<T, T>(key, key, index, distance);
    }
}

