/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.math.blas.Transpose;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;
import smile.math.matrix.SparseMatrix;
import smile.math.matrix.SymmMatrix;
import smile.util.SparseArray;
import smile.util.Strings;

public abstract class IMatrix
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(IMatrix.class);
    private String[] rowNames;
    private String[] colNames;

    public IMatrix copy() {
        throw new UnsupportedOperationException();
    }

    public abstract int nrow();

    public abstract int ncol();

    public abstract long size();

    public String[] rowNames() {
        return this.rowNames;
    }

    public void rowNames(String[] names) {
        if (names != null && names.length != this.nrow()) {
            throw new IllegalArgumentException(String.format("Invalid row names length: %d != %d", names.length, this.nrow()));
        }
        this.rowNames = names;
    }

    public String rowName(int i) {
        return this.rowNames[i];
    }

    public String[] colNames() {
        return this.colNames;
    }

    public void colNames(String[] names) {
        if (names != null && names.length != this.ncol()) {
            throw new IllegalArgumentException(String.format("Invalid column names length: %d != %d", names.length, this.ncol()));
        }
        this.colNames = names;
    }

    public String colName(int i) {
        return this.colNames[i];
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        return full ? this.toString(this.nrow(), this.ncol()) : this.toString(7, 7);
    }

    public String toString(int m, int n) {
        String newline;
        StringBuilder sb = new StringBuilder(this.nrow() + " x " + this.ncol() + "\n");
        m = Math.min(m, this.nrow());
        String string = newline = (n = Math.min(n, this.ncol())) < this.ncol() ? "  ...\n" : "\n";
        if (this.colNames != null) {
            if (this.rowNames != null) {
                sb.append("            ");
            }
            for (int j = 0; j < n; ++j) {
                sb.append(String.format(" %12.12s", this.colNames[j]));
            }
            sb.append(newline);
        }
        for (int i = 0; i < m; ++i) {
            if (this.rowNames != null) {
                sb.append(String.format("%-12.12s", this.rowNames[i]));
            }
            for (int j = 0; j < n; ++j) {
                sb.append(String.format(" %12.12s", this.str(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrow()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }

    private String str(int i, int j) {
        return Strings.format(this.get(i, j), true);
    }

    public abstract void mv(Transpose var1, double var2, double[] var4, double var5, double[] var7);

    public double[] mv(double[] x) {
        double[] y = new double[this.nrow()];
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    public void mv(double[] x, double[] y) {
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
    }

    public void mv(double alpha, double[] x, double beta, double[] y) {
        this.mv(Transpose.NO_TRANSPOSE, alpha, x, beta, y);
    }

    public abstract void mv(double[] var1, int var2, int var3);

    public double[] tv(double[] x) {
        double[] y = new double[this.ncol()];
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    public void tv(double[] x, double[] y) {
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
    }

    public void tv(double alpha, double[] x, double beta, double[] y) {
        this.mv(Transpose.TRANSPOSE, alpha, x, beta, y);
    }

    public abstract void tv(double[] var1, int var2, int var3);

    static int ld(int n) {
        int elementSize = 4;
        if (n <= 256 / elementSize) {
            return n;
        }
        return ((n * elementSize + 511) / 512 * 512 + 64) / elementSize;
    }

    static Transpose flip(Transpose trans) {
        return trans == Transpose.NO_TRANSPOSE ? Transpose.TRANSPOSE : Transpose.NO_TRANSPOSE;
    }

    public void set(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    public void update(int i, int j, double x) {
        this.set(i, j, x);
    }

    public double get(int i, int j) {
        throw new UnsupportedOperationException();
    }

    public double apply(int i, int j) {
        return this.get(i, j);
    }

    public double[] diag() {
        int n = Math.min(this.nrow(), this.ncol());
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.get(i, i);
        }
        return d;
    }

    public double trace() {
        int n = Math.min(this.nrow(), this.ncol());
        double t2 = 0.0;
        for (int i = 0; i < n; ++i) {
            t2 += this.get(i, i);
        }
        return t2;
    }

    public double eigen(double[] v) {
        return this.eigen(v, 0.0, Math.max(1.0E-6, (double)this.nrow() * MathEx.EPSILON), Math.max(20, 2 * this.nrow()));
    }

    public double eigen(double[] v, double p, double tol, int maxIter) {
        if (this.nrow() != this.ncol()) {
            throw new IllegalArgumentException("Matrix is not square.");
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int n = this.nrow();
        tol = Math.max(tol, MathEx.EPSILON * (double)n);
        double[] z = new double[n];
        double lambda = this.power(v, z, p);
        for (int iter = 1; iter <= maxIter; ++iter) {
            double l = lambda;
            lambda = this.power(v, z, p);
            double eps = Math.abs(lambda - l);
            if (iter % 10 == 0) {
                logger.trace("Largest eigenvalue after {} power iterations: {}", (Object)iter, (Object)(lambda + p));
            }
            if (!(eps < tol)) continue;
            logger.info("Largest eigenvalue after {} power iterations: {}", (Object)iter, (Object)(lambda + p));
            return lambda + p;
        }
        logger.info("Largest eigenvalue after {} power iterations: {}", (Object)maxIter, (Object)(lambda + p));
        logger.error("Power iteration exceeded the maximum number of iterations.");
        return lambda + p;
    }

    private double power(double[] x, double[] y, double p) {
        int i;
        this.mv(x, y);
        if (p != 0.0) {
            for (int i2 = 0; i2 < y.length; ++i2) {
                int n = i2;
                y[n] = y[n] - p * x[i2];
            }
        }
        double lambda = y[0];
        for (i = 1; i < y.length; ++i) {
            if (!(Math.abs(y[i]) > Math.abs(lambda))) continue;
            lambda = y[i];
        }
        for (i = 0; i < y.length; ++i) {
            x[i] = y[i] / lambda;
        }
        return lambda;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMatrix market(Path path) throws IOException, ParseException {
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));
             Scanner scanner = new Scanner(reader);){
            int i;
            ArrayList<SparseArray> rows;
            int[] colSize;
            int nz;
            int ncol;
            int nrow;
            String line;
            boolean skew;
            boolean symmetric;
            block48: {
                block47: {
                    block45: {
                        Matrix matrix;
                        int ncol2;
                        int nrow2;
                        block43: {
                            block46: {
                                block44: {
                                    String format;
                                    block42: {
                                        String header = scanner.next();
                                        if (!header.equals("%%MatrixMarket")) {
                                            throw new ParseException("Invalid Matrix Market file header", reader.getLineNumber());
                                        }
                                        String object = scanner.next();
                                        if (!object.equals("matrix")) {
                                            throw new UnsupportedOperationException("The object is not a matrix file: " + object);
                                        }
                                        format = scanner.next();
                                        String field = scanner.next();
                                        if (field.equals("complex")) throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        if (field.equals("pattern")) {
                                            throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        }
                                        String symmetry = scanner.nextLine().trim();
                                        if (symmetry.equals("Hermitian")) {
                                            throw new UnsupportedOperationException("No support of Hermitian matrix");
                                        }
                                        symmetric = symmetry.equals("symmetric");
                                        skew = symmetry.equals("skew-symmetric");
                                        line = scanner.nextLine();
                                        while (line.startsWith("%")) {
                                            line = scanner.nextLine();
                                        }
                                        if (!format.equals("array")) break block42;
                                        Scanner s = new Scanner(line);
                                        nrow2 = s.nextInt();
                                        ncol2 = s.nextInt();
                                        matrix = new Matrix(nrow2, ncol2);
                                        break block43;
                                    }
                                    if (!format.equals("coordinate")) throw new ParseException("Invalid Matrix Market format: " + format, 0);
                                    Scanner s = new Scanner(line);
                                    nrow = s.nextInt();
                                    ncol = s.nextInt();
                                    nz = s.nextInt();
                                    if (!symmetric || nz != nrow * (nrow + 1) / 2) break block44;
                                    if (nrow != ncol) {
                                        throw new IllegalStateException(String.format("Symmetric matrix is not square: %d != %d", nrow, ncol));
                                    }
                                    break block45;
                                }
                                if (!skew || nz != nrow * (nrow + 1) / 2) break block46;
                                if (nrow != ncol) {
                                    throw new IllegalStateException(String.format("Skew-symmetric matrix is not square: %d != %d", nrow, ncol));
                                }
                                break block47;
                            }
                            colSize = new int[ncol];
                            rows = new ArrayList<SparseArray>();
                            for (int i2 = 0; i2 < nrow; ++i2) {
                                rows.add(new SparseArray());
                            }
                            break block48;
                        }
                        for (int j = 0; j < ncol2; ++j) {
                            for (int i3 = 0; i3 < nrow2; ++i3) {
                                double x = scanner.nextDouble();
                                matrix.set(i3, j, x);
                            }
                        }
                        if (symmetric) {
                            matrix.uplo(UPLO.LOWER);
                        }
                        Matrix j = matrix;
                        return j;
                    }
                    SymmMatrix matrix = new SymmMatrix(UPLO.LOWER, nrow);
                    int k2 = 0;
                    while (true) {
                        if (k2 >= nz) {
                            SymmMatrix k2 = matrix;
                            return k2;
                        }
                        String[] tokens = scanner.nextLine().trim().split("\\s+");
                        if (tokens.length != 3) {
                            throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                        }
                        int i4 = Integer.parseInt(tokens[0]) - 1;
                        int j = Integer.parseInt(tokens[1]) - 1;
                        double x = Double.parseDouble(tokens[2]);
                        matrix.set(i4, j, x);
                        ++k2;
                    }
                }
                Matrix matrix = new Matrix(nrow, ncol);
                int k3 = 0;
                while (true) {
                    if (k3 >= nz) {
                        Matrix k3 = matrix;
                        return k3;
                    }
                    String[] tokens = scanner.nextLine().trim().split("\\s+");
                    if (tokens.length != 3) {
                        throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                    }
                    int i5 = Integer.parseInt(tokens[0]) - 1;
                    int j = Integer.parseInt(tokens[1]) - 1;
                    double x = Double.parseDouble(tokens[2]);
                    matrix.set(i5, j, x);
                    matrix.set(j, i5, -x);
                    ++k3;
                }
            }
            for (int k = 0; k < nz; ++k) {
                String[] tokens = scanner.nextLine().trim().split("\\s+");
                if (tokens.length != 3) {
                    throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                }
                i = Integer.parseInt(tokens[0]) - 1;
                int j = Integer.parseInt(tokens[1]) - 1;
                double x = Double.parseDouble(tokens[2]);
                SparseArray row = (SparseArray)rows.get(i);
                row.set(j, x);
                int n = j;
                colSize[n] = colSize[n] + 1;
                if (symmetric) {
                    row = (SparseArray)rows.get(j);
                    row.set(i, x);
                    int n2 = i;
                    colSize[n2] = colSize[n2] + 1;
                    continue;
                }
                if (!skew) continue;
                row = (SparseArray)rows.get(j);
                row.set(i, -x);
                int n3 = i;
                colSize[n3] = colSize[n3] + 1;
            }
            int[] pos = new int[ncol];
            int[] colIndex = new int[ncol + 1];
            for (i = 0; i < ncol; ++i) {
                colIndex[i + 1] = colIndex[i] + colSize[i];
            }
            if (symmetric || skew) {
                nz *= 2;
            }
            int[] rowIndex = new int[nz];
            double[] x = new double[nz];
            for (int i6 = 0; i6 < nrow; ++i6) {
                for (SparseArray.Entry e : (SparseArray)rows.get(i6)) {
                    int j = e.i;
                    int k = colIndex[j] + pos[j];
                    rowIndex[k] = i6;
                    x[k] = e.x;
                    int n = j;
                    pos[n] = pos[n] + 1;
                }
            }
            SparseMatrix sparseMatrix = new SparseMatrix(nrow, ncol, x, rowIndex, colIndex);
            return sparseMatrix;
        }
    }

    public IMatrix square() {
        return new Square(this);
    }

    public Preconditioner Jacobi() {
        double[] diag = this.diag();
        return (b, x) -> {
            int n = diag.length;
            for (int i = 0; i < n; ++i) {
                x[i] = diag[i] != 0.0 ? b[i] / diag[i] : b[i];
            }
        };
    }

    public double solve(double[] b, double[] x) {
        return this.solve(b, x, this.Jacobi(), 1.0E-6, 1, 2 * Math.max(this.nrow(), this.ncol()));
    }

    public double solve(double[] b, double[] x, Preconditioner P, double tol, int itol, int maxIter) {
        double bnrm;
        int j;
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (itol < 1 || itol > 4) {
            throw new IllegalArgumentException("Invalid itol: " + itol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum iterations: " + maxIter);
        }
        double err = 0.0;
        double bkden = 1.0;
        double znrm = 0.0;
        int n = b.length;
        double[] p = new double[n];
        double[] pp = new double[n];
        double[] r = new double[n];
        double[] rr = new double[n];
        double[] z = new double[n];
        double[] zz = new double[n];
        this.mv(x, r);
        for (j = 0; j < n; ++j) {
            r[j] = b[j] - r[j];
            rr[j] = r[j];
        }
        if (itol == 1) {
            bnrm = IMatrix.norm(b, itol);
            P.asolve(r, z);
        } else if (itol == 2) {
            P.asolve(b, z);
            bnrm = IMatrix.norm(z, itol);
            P.asolve(r, z);
        } else {
            P.asolve(b, z);
            bnrm = IMatrix.norm(z, itol);
            P.asolve(r, z);
            znrm = IMatrix.norm(z, itol);
        }
        for (int iter = 1; iter <= maxIter; ++iter) {
            P.asolve(rr, zz);
            double bknum = 0.0;
            for (j = 0; j < n; ++j) {
                bknum += z[j] * rr[j];
            }
            if (iter == 1) {
                for (j = 0; j < n; ++j) {
                    p[j] = z[j];
                    pp[j] = zz[j];
                }
            } else {
                double bk = bknum / bkden;
                for (j = 0; j < n; ++j) {
                    p[j] = bk * p[j] + z[j];
                    pp[j] = bk * pp[j] + zz[j];
                }
            }
            bkden = bknum;
            this.mv(p, z);
            double akden = 0.0;
            for (j = 0; j < n; ++j) {
                akden += z[j] * pp[j];
            }
            double ak = bknum / akden;
            this.tv(pp, zz);
            for (j = 0; j < n; ++j) {
                int n2 = j;
                x[n2] = x[n2] + ak * p[j];
                int n3 = j;
                r[n3] = r[n3] - ak * z[j];
                int n4 = j;
                rr[n4] = rr[n4] - ak * zz[j];
            }
            P.asolve(r, z);
            if (itol == 1) {
                err = IMatrix.norm(r, itol) / bnrm;
            } else if (itol == 2) {
                err = IMatrix.norm(z, itol) / bnrm;
            } else {
                double zm1nrm = znrm;
                if (!(Math.abs(zm1nrm - (znrm = IMatrix.norm(z, itol))) > MathEx.EPSILON * znrm)) {
                    err = znrm / bnrm;
                    continue;
                }
                double dxnrm = Math.abs(ak) * IMatrix.norm(p, itol);
                err = znrm / Math.abs(zm1nrm - znrm) * dxnrm;
                double xnrm = IMatrix.norm(x, itol);
                if (err <= 0.5 * xnrm) {
                    err /= xnrm;
                } else {
                    err = znrm / bnrm;
                    continue;
                }
            }
            if (iter % 10 == 0) {
                logger.info("BCG: the error after {} iterations: {}", (Object)iter, (Object)err);
            }
            if (!(err <= tol)) continue;
            logger.info("BCG: the error after {} iterations: {}", (Object)iter, (Object)err);
            break;
        }
        return err;
    }

    private static double norm(double[] x, int itol) {
        int n = x.length;
        if (itol <= 3) {
            double ans = 0.0;
            for (double v : x) {
                ans += v * v;
            }
            return Math.sqrt(ans);
        }
        int isamax = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(x[i]) > Math.abs(x[isamax]))) continue;
            isamax = i;
        }
        return Math.abs(x[isamax]);
    }

    static class Square
    extends IMatrix {
        private final IMatrix A;
        private final int m;
        private final int n;
        private final double[] Ax;

        public Square(IMatrix A) {
            this.A = A;
            this.m = Math.max(A.nrow(), A.ncol());
            this.n = Math.min(A.nrow(), A.ncol());
            this.Ax = new double[this.m + this.n];
        }

        @Override
        public int nrow() {
            return this.n;
        }

        @Override
        public int ncol() {
            return this.n;
        }

        @Override
        public long size() {
            return this.A.size();
        }

        @Override
        public void mv(Transpose trans, double alpha, double[] x, double beta, double[] y) {
            if (this.A.nrow() >= this.A.ncol()) {
                this.A.mv(x, this.Ax);
                this.A.tv(alpha, this.Ax, beta, y);
            } else {
                this.A.tv(x, this.Ax);
                this.A.mv(alpha, this.Ax, beta, y);
            }
        }

        @Override
        public void mv(double[] work, int inputOffset, int outputOffset) {
            System.arraycopy(work, inputOffset, this.Ax, 0, this.n);
            if (this.A.nrow() >= this.A.ncol()) {
                this.A.mv(this.Ax, 0, this.n);
                this.A.tv(this.Ax, this.n, 0);
            } else {
                this.A.tv(this.Ax, 0, this.n);
                this.A.mv(this.Ax, this.n, 0);
            }
            System.arraycopy(this.Ax, 0, work, outputOffset, this.n);
        }

        @Override
        public void tv(double[] work, int inputOffset, int outputOffset) {
            this.mv(work, inputOffset, outputOffset);
        }
    }

    public static interface Preconditioner {
        public void asolve(double[] var1, double[] var2);
    }
}

