/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.Laplacian;
import smile.math.kernel.MercerKernel;

public class LaplacianKernel
extends Laplacian
implements MercerKernel<double[]> {
    public LaplacianKernel(double sigma) {
        this(sigma, 1.0E-5, 100000.0);
    }

    public LaplacianKernel(double sigma, double lo, double hi) {
        super(sigma, lo, hi);
    }

    @Override
    public double k(double[] x, double[] y) {
        return this.k(MathEx.distance(x, y));
    }

    @Override
    public double[] kg(double[] x, double[] y) {
        return this.kg(MathEx.distance(x, y));
    }

    public LaplacianKernel of(double[] params) {
        return new LaplacianKernel(params[0], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.sigma};
    }

    @Override
    public double[] lo() {
        return new double[]{this.lo};
    }

    @Override
    public double[] hi() {
        return new double[]{this.hi};
    }
}

