/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.blas.UPLO;
import smile.math.distance.Metric;
import smile.math.matrix.Matrix;

public class MahalanobisDistance
implements Metric<double[]> {
    private static final long serialVersionUID = 1L;
    private final Matrix sigma;
    private final Matrix sigmaInv;

    public MahalanobisDistance(double[][] cov) {
        this.sigma = Matrix.of(cov);
        this.sigma.uplo(UPLO.LOWER);
        this.sigmaInv = this.sigma.inverse();
    }

    public String toString() {
        return String.format("Mahalanobis Distance(%s)", this.sigma);
    }

    @Override
    public double d(double[] x, double[] y) {
        if (x.length != this.sigma.nrow()) {
            throw new IllegalArgumentException(String.format("Array x[%d] has different dimension with Sigma[%d][%d].", x.length, this.sigma.nrow(), this.sigma.ncol()));
        }
        if (y.length != this.sigma.nrow()) {
            throw new IllegalArgumentException(String.format("Array y[%d] has different dimension with Sigma[%d][%d].", y.length, this.sigma.nrow(), this.sigma.ncol()));
        }
        int n = x.length;
        double[] z = new double[n];
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] - y[i];
        }
        double dist = this.sigmaInv.xAx(z);
        return Math.sqrt(dist);
    }
}

