/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public interface Input {
    public static BufferedReader reader(String path) throws IOException, URISyntaxException {
        return new BufferedReader(new InputStreamReader(Input.stream(path)));
    }

    public static BufferedReader reader(String path, Charset charset) throws IOException, URISyntaxException {
        return new BufferedReader(new InputStreamReader(Input.stream(path), charset));
    }

    public static InputStream stream(String path) throws IOException, URISyntaxException {
        if (path.matches("([a-zA-Z]:\\\\)?[\\\\\\S|*]?.*")) {
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        URI uri = new URI(path);
        String scheme = uri.getScheme();
        if (scheme == null || scheme.length() < 2) {
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return Files.newInputStream(Paths.get(uri.getPath(), new String[0]), new OpenOption[0]);
        }
        return uri.toURL().openStream();
    }
}

