/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import java.util.Arrays;
import smile.gap.Chromosome;
import smile.math.MathEx;

public interface Selection {
    public <T extends Chromosome<T>> T apply(T[] var1);

    public static Selection RouletteWheel() {
        return new Selection(){

            @Override
            public <T extends Chromosome<T>> T apply(T[] population) {
                int size = population.length;
                double worst = population[0].fitness();
                if (worst > 0.0) {
                    worst = 0.0;
                }
                double[] fitness = new double[size];
                for (int i = 0; i < size; ++i) {
                    fitness[i] = population[i].fitness() - worst;
                }
                MathEx.unitize1(fitness);
                return population[MathEx.random(fitness)];
            }
        };
    }

    public static Selection ScaledRouletteWheel() {
        return new Selection(){

            @Override
            public <T extends Chromosome<T>> T apply(T[] population) {
                int size = population.length;
                double worst = population[0].fitness();
                double[] fitness = new double[size];
                for (int i = 0; i < size; ++i) {
                    fitness[i] = population[i].fitness() - worst;
                }
                MathEx.unitize1(fitness);
                return population[MathEx.random(fitness)];
            }
        };
    }

    public static Selection Rank() {
        return new Selection(){

            @Override
            public <T extends Chromosome<T>> T apply(T[] population) {
                int size = population.length;
                double[] fitness = new double[size];
                for (int i = 0; i < size; ++i) {
                    fitness[i] = i + 1;
                }
                MathEx.unitize1(fitness);
                return population[MathEx.random(fitness)];
            }
        };
    }

    public static Selection Tournament(final int size, final double probability) {
        return new Selection(){

            @Override
            public <T extends Chromosome<T>> T apply(T[] population) {
                int i;
                Object[] pool = new Chromosome[size];
                for (i = 0; i < size; ++i) {
                    pool[i] = population[MathEx.randomInt(population.length)];
                }
                Arrays.sort(pool);
                for (i = 1; i <= size; ++i) {
                    double p = MathEx.random();
                    if (!(p < probability)) continue;
                    return (T)pool[size - i];
                }
                return (T)pool[size - 1];
            }
        };
    }
}

