/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.vector.NumberVector;
import smile.data.vector.VectorImpl;

class NumberVectorImpl
extends VectorImpl<Number>
implements NumberVector {
    public NumberVectorImpl(String name, Class<?> clazz, Number[] vector) {
        super(name, clazz, vector);
    }

    public NumberVectorImpl(String name, DataType type, Number[] vector) {
        super(name, type, vector);
    }

    public NumberVectorImpl(StructField field, Number[] vector) {
        super(field, vector);
    }

    @Override
    public NumberVector get(int ... index) {
        Number[] v = new Number[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = ((Number[])this.vector)[index[i]];
        }
        return new NumberVectorImpl(this.field(), v);
    }

    @Override
    public void fillna(double value) {
        Number number = switch (this.type().id()) {
            case DataType.ID.Byte -> (byte)value;
            case DataType.ID.Short -> (short)value;
            case DataType.ID.Integer -> (int)value;
            case DataType.ID.Long -> (long)value;
            case DataType.ID.Float -> Float.valueOf((float)value);
            case DataType.ID.Double -> value;
            default -> throw new UnsupportedOperationException("Unsupported type: " + String.valueOf((Object)this.type().id()));
        };
        for (int i = 0; i < ((Number[])this.vector).length; ++i) {
            if (((Number[])this.vector)[i] == null) {
                ((Number[])this.vector)[i] = number;
                continue;
            }
            double x = ((Number[])this.vector)[i].doubleValue();
            if (!Double.isNaN(x) && !Double.isInfinite(x)) continue;
            ((Number[])this.vector)[i] = number;
        }
    }
}

