/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.FloatVectorImpl;
import smile.math.MathEx;

public interface FloatVector
extends BaseVector<Float, Double, DoubleStream> {
    @Override
    default public DataType type() {
        return DataTypes.FloatType;
    }

    public float[] array();

    public FloatVector get(int ... var1);

    @Override
    default public boolean getBoolean(int i) {
        return MathEx.isZero(this.getFloat(i));
    }

    @Override
    default public char getChar(int i) {
        return (char)this.getFloat(i);
    }

    @Override
    default public byte getByte(int i) {
        return (byte)this.getFloat(i);
    }

    @Override
    default public short getShort(int i) {
        return (short)this.getFloat(i);
    }

    @Override
    default public int getInt(int i) {
        return (int)this.getFloat(i);
    }

    @Override
    default public long getLong(int i) {
        return (long)this.getFloat(i);
    }

    @Override
    default public double getDouble(int i) {
        return this.getFloat(i);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((DoubleStream)this.stream()).limit(n).mapToObj(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public void fillna(float var1);

    public static FloatVector of(String name, float[] vector) {
        return new FloatVectorImpl(name, vector);
    }

    public static FloatVector of(StructField field, float[] vector) {
        return new FloatVectorImpl(field, vector);
    }
}

