/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.ByteVectorImpl;

public interface ByteVector
extends BaseVector<Byte, Integer, IntStream> {
    @Override
    default public DataType type() {
        return DataTypes.ByteType;
    }

    public byte[] array();

    public ByteVector get(int ... var1);

    @Override
    default public boolean getBoolean(int i) {
        return this.getByte(i) != 0;
    }

    @Override
    default public char getChar(int i) {
        return (char)this.getByte(i);
    }

    @Override
    default public short getShort(int i) {
        return this.getByte(i);
    }

    @Override
    default public int getInt(int i) {
        return this.getByte(i);
    }

    @Override
    default public long getLong(int i) {
        return this.getByte(i);
    }

    @Override
    default public float getFloat(int i) {
        return this.getByte(i);
    }

    @Override
    default public double getDouble(int i) {
        return this.getByte(i);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((IntStream)this.stream()).limit(n).mapToObj(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public static ByteVector of(String name, byte[] vector) {
        return new ByteVectorImpl(name, vector);
    }

    public static ByteVector of(StructField field, byte[] vector) {
        return new ByteVectorImpl(field, vector);
    }
}

