/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVectorImpl;

public interface BooleanVector
extends BaseVector<Boolean, Integer, IntStream> {
    @Override
    default public DataType type() {
        return DataTypes.BooleanType;
    }

    public boolean[] array();

    public BooleanVector get(int ... var1);

    @Override
    default public char getChar(int i) {
        return this.getBoolean(i) ? (char)'T' : 'F';
    }

    @Override
    default public byte getByte(int i) {
        return this.getBoolean(i) ? (byte)1 : 0;
    }

    @Override
    default public short getShort(int i) {
        return this.getBoolean(i) ? (short)1 : 0;
    }

    @Override
    default public int getInt(int i) {
        return this.getBoolean(i) ? 1 : 0;
    }

    @Override
    default public long getLong(int i) {
        return this.getBoolean(i) ? 1L : 0L;
    }

    @Override
    default public float getFloat(int i) {
        return this.getBoolean(i) ? 1.0f : 0.0f;
    }

    @Override
    default public double getDouble(int i) {
        return this.getBoolean(i) ? 1.0 : 0.0;
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((IntStream)this.stream()).limit(n).mapToObj(String::valueOf).collect(Collectors.joining(", ", "[", suffix));
    }

    public static BooleanVector of(String name, boolean[] vector) {
        return new BooleanVectorImpl(name, vector);
    }

    public static BooleanVector of(StructField field, boolean[] vector) {
        return new BooleanVectorImpl(field, vector);
    }
}

