/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.io.Serializable;
import java.util.stream.BaseStream;
import smile.data.measure.Measure;
import smile.data.type.DataType;
import smile.data.type.StructField;

public interface BaseVector<T, TS, S extends BaseStream<TS, S>>
extends Serializable {
    public String name();

    public DataType type();

    default public Measure measure() {
        return null;
    }

    default public StructField field() {
        return new StructField(this.name(), this.type(), this.measure());
    }

    public int size();

    public Object array();

    default public double[] toDoubleArray() {
        return this.toDoubleArray(new double[this.size()]);
    }

    default public double[] toDoubleArray(double[] a) {
        throw new UnsupportedOperationException(this.name() + ":" + String.valueOf(this.type()));
    }

    default public int[] toIntArray() {
        return this.toIntArray(new int[this.size()]);
    }

    default public int[] toIntArray(int[] a) {
        throw new UnsupportedOperationException();
    }

    default public String[] toStringArray() {
        return this.toStringArray(new String[this.size()]);
    }

    default public String[] toStringArray(String[] a) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = this.field().toString(this.get(i));
        }
        return a;
    }

    public T get(int var1);

    public BaseVector<T, TS, S> get(int ... var1);

    public boolean getBoolean(int var1);

    public char getChar(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    default public T apply(int i) {
        return this.get(i);
    }

    default public BaseVector<T, TS, S> apply(int ... index) {
        return this.get(index);
    }

    public S stream();
}

