/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.Tuple;
import smile.data.measure.Measure;
import smile.data.type.DataType;
import smile.data.type.StructField;

public class StructType
implements DataType {
    private final StructField[] fields;
    private final Map<String, Integer> index;

    public StructType(List<StructField> fields) {
        this(fields.toArray(new StructField[0]));
    }

    public StructType(StructField ... fields) {
        this.fields = fields;
        this.index = new HashMap<String, Integer>(fields.length * 4 / 3);
        for (int i = 0; i < fields.length; ++i) {
            this.index.put(fields[i].name, i);
        }
    }

    public int length() {
        return this.fields.length;
    }

    public StructField[] fields() {
        return this.fields;
    }

    public StructField field(String name) {
        return this.fields[this.indexOf(name)];
    }

    public StructField field(int i) {
        return this.fields[i];
    }

    public int indexOf(String field) {
        if (!this.index.containsKey(field)) {
            throw new IllegalArgumentException(String.format("Field %s doesn't exist", field));
        }
        return this.index.get(field);
    }

    public String name(int i) {
        return this.fields[i].name;
    }

    public String[] names() {
        return (String[])Arrays.stream(this.fields).map(field -> field.name).toArray(String[]::new);
    }

    public DataType type(int i) {
        return this.fields[i].type;
    }

    public DataType[] types() {
        return Arrays.stream(this.fields).map(field -> field.type).toList().toArray(new DataType[0]);
    }

    public Measure measure(int i) {
        return this.fields[i].measure;
    }

    public Measure[] measures() {
        return (Measure[])Arrays.stream(this.fields).map(field -> field.measure).toArray(Measure[]::new);
    }

    public List<Function<String, Object>> parser() {
        ArrayList<Function<String, Object>> parser = new ArrayList<Function<String, Object>>();
        for (StructField field : this.fields) {
            parser.add(field::valueOf);
        }
        return parser;
    }

    public StructType boxed(Collection<Tuple> rows) {
        return new StructType((StructField[])IntStream.range(0, this.length()).mapToObj(i -> {
            StructField field = this.fields[i];
            if (field.type.isPrimitive()) {
                int idx = i;
                boolean missing = rows.stream().anyMatch(t2 -> t2.isNullAt(idx));
                if (missing) {
                    field = new StructField(field.name, field.type.boxed(), field.measure);
                }
            }
            return field;
        }).toArray(StructField[]::new));
    }

    @Override
    public StructType unboxed() {
        return new StructType((StructField[])IntStream.range(0, this.length()).mapToObj(i -> {
            StructField field = this.fields[i];
            if (field.type.isObject()) {
                field = new StructField(field.name, field.type.unboxed(), field.measure);
            }
            return field;
        }).toArray(StructField[]::new));
    }

    @Override
    public String name() {
        return Arrays.stream(this.fields).map(field -> String.format("%s: %s", field.name, field.type.name())).collect(Collectors.joining(", ", "Struct[", "]"));
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Struct;
    }

    public String toString() {
        return Arrays.toString(this.fields);
    }

    @Override
    public String toString(Object o) {
        Tuple t2 = (Tuple)o;
        return Arrays.stream(this.fields).map(field -> {
            Object v = t2.get(field.name);
            String value = v == null ? "null" : field.toString(v);
            return String.format("  %s: %s", field.name, value);
        }).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }

    @Override
    public Tuple valueOf(String s) {
        String[] elements = s.substring(1, s.length() - 1).split(",");
        Object[] row = new Object[this.fields.length];
        for (String element : elements) {
            String[] pair = element.split(":");
            int i = this.index.get(pair[0]);
            row[i] = this.fields[i].valueOf(pair[1]);
        }
        return Tuple.of(row, this);
    }

    public boolean equals(Object o) {
        if (o instanceof StructType) {
            StructType t2 = (StructType)o;
            return Arrays.equals(this.fields, t2.fields);
        }
        return false;
    }
}

