/*
 * Decompiled with CFR 0.152.
 */
package smile.data.transform;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.measure.NumericalMeasure;
import smile.data.transform.Transform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.DoubleVector;
import smile.math.Function;

public class ColumnTransform
implements Transform {
    private final String name;
    private final Map<String, Function> transforms;

    public ColumnTransform(String name, Map<String, Function> transforms) {
        this.name = name;
        this.transforms = transforms;
    }

    @Override
    public Tuple apply(final Tuple x) {
        final StructType schema = x.schema();
        return new AbstractTuple(){

            @Override
            public Object get(int i) {
                Function transform = ColumnTransform.this.transforms.get(schema.field((int)i).name);
                if (transform != null) {
                    return transform.apply(x.getDouble(i));
                }
                return x.get(i);
            }

            @Override
            public StructType schema() {
                return schema;
            }
        };
    }

    @Override
    public DataFrame apply(DataFrame data) {
        StructType schema = data.schema();
        BaseVector[] vectors = new BaseVector[schema.length()];
        IntStream.range(0, schema.length()).parallel().forEach(i -> {
            StructField field = schema.field(i);
            Function transform = this.transforms.get(field.name);
            if (transform != null) {
                DoubleStream stream = data.stream().mapToDouble(t2 -> transform.apply(t2.getDouble(i)));
                vectors[i] = field.measure == null || field.measure instanceof NumericalMeasure ? DoubleVector.of(field, stream) : DoubleVector.of(field.name, stream);
            } else {
                vectors[i] = data.column(i);
            }
        });
        return DataFrame.of(vectors);
    }

    public String toString() {
        return this.transforms.values().stream().map(Object::toString).collect(Collectors.joining(",\n  ", this.name + "(\n  ", "\n)"));
    }
}

