/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Abs
extends AbstractFunction {
    public Abs(Term x) {
        super("abs", x);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final Feature feature : this.x.bind(schema)) {
            final StructField xfield = feature.field();
            DataType type = xfield.type;
            if (!(type.isInt() || type.isLong() || type.isDouble() || type.isFloat())) {
                throw new IllegalStateException(String.format("Invalid expression: abs(%s)", type));
            }
            features.add(new Feature(){
                final StructField field;
                {
                    this.field = new StructField(String.format("abs(%s)", xfield.name), xfield.type, xfield.measure);
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Object apply(Tuple o) {
                    Object y;
                    Object object = y = feature.apply(o);
                    int n = 0;
                    return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Integer.class, Float.class, Long.class, Short.class, Byte.class}, (Object)object, n)) {
                        case -1 -> null;
                        case 0 -> {
                            Double v = (Double)object;
                            yield Math.abs(v);
                        }
                        case 1 -> {
                            Integer i = (Integer)object;
                            yield Math.abs(i);
                        }
                        case 2 -> {
                            Float v = (Float)object;
                            yield Float.valueOf(Math.abs(v.floatValue()));
                        }
                        case 3 -> {
                            Long l = (Long)object;
                            yield Math.abs(l);
                        }
                        case 4 -> {
                            Short s = (Short)object;
                            yield Math.abs(s.shortValue());
                        }
                        case 5 -> {
                            Byte b = (Byte)object;
                            yield Math.abs(b.byteValue());
                        }
                        default -> throw new IllegalArgumentException("Invalid argument for abs(): " + String.valueOf(y));
                    };
                }

                @Override
                public int applyAsInt(Tuple o) {
                    return Math.abs(feature.applyAsInt(o));
                }

                @Override
                public long applyAsLong(Tuple o) {
                    return Math.abs(feature.applyAsLong(o));
                }

                @Override
                public float applyAsFloat(Tuple o) {
                    return Math.abs(feature.applyAsFloat(o));
                }

                @Override
                public double applyAsDouble(Tuple o) {
                    return Math.abs(feature.applyAsDouble(o));
                }
            });
        }
        return features;
    }
}

