/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SampleInstance;
import smile.data.SparseDataset;
import smile.util.SparseArray;

class SparseDatasetImpl<T>
implements SparseDataset<T> {
    private static final Logger logger = LoggerFactory.getLogger(SparseDatasetImpl.class);
    private final ArrayList<SampleInstance<SparseArray, T>> instances;
    private int n;
    private final int ncol;
    private int[] colSize;

    public SparseDatasetImpl(Collection<SampleInstance<SparseArray, T>> data) {
        this(data, 1 + data.stream().flatMap(instance -> ((SparseArray)instance.x()).stream()).mapToInt(e -> e.i).max().orElse(0));
    }

    public SparseDatasetImpl(Collection<SampleInstance<SparseArray, T>> data, int ncol) {
        this.instances = new ArrayList<SampleInstance<SparseArray, T>>(data);
        this.ncol = ncol;
        this.colSize = new int[ncol];
        for (SampleInstance<SparseArray, T> instance : data) {
            SparseArray x = instance.x();
            x.sort();
            int i = -1;
            for (SparseArray.Entry e : x) {
                if (e.i < 0) {
                    throw new IllegalArgumentException(String.format("Negative index of nonzero element: %d", e.i));
                }
                if (e.i == i) {
                    logger.warn("Ignore duplicated indices: {} in {}", (Object)e.i, (Object)x);
                    continue;
                }
                if (ncol <= e.i) {
                    ncol = e.i + 1;
                    int[] newColSize = new int[3 * ncol / 2];
                    System.arraycopy(this.colSize, 0, newColSize, 0, this.colSize.length);
                    this.colSize = newColSize;
                }
                int n = e.i;
                this.colSize[n] = this.colSize[n] + 1;
                ++this.n;
                i = e.i;
            }
        }
    }

    @Override
    public int size() {
        return this.instances.size();
    }

    @Override
    public int nz() {
        return this.n;
    }

    @Override
    public int nz(int j) {
        return this.colSize[j];
    }

    @Override
    public int ncol() {
        return this.ncol;
    }

    @Override
    public SampleInstance<SparseArray, T> get(int i) {
        return this.instances.get(i);
    }

    @Override
    public Stream<SampleInstance<SparseArray, T>> stream() {
        return this.instances.stream();
    }

    @Override
    public Iterator<SampleInstance<SparseArray, T>> iterator() {
        return this.instances.iterator();
    }
}

