/*
 * Decompiled with CFR 0.152.
 */
package smile.stat;

import java.util.Arrays;
import smile.math.MathEx;
import smile.util.IntSet;

public interface Sampling {
    public static int[] random(int n, double subsample) {
        if (subsample == 1.0) {
            int[] samples = new int[n];
            for (int i = 0; i < n; ++i) {
                samples[i] = MathEx.randomInt(n);
            }
            return samples;
        }
        int size = (int)Math.round(subsample * (double)n);
        int[] samples = MathEx.permutate(n);
        return Arrays.copyOf(samples, size);
    }

    public static int[][] strata(int[] category) {
        int[] unique = MathEx.unique(category);
        int m = unique.length;
        Arrays.sort(unique);
        IntSet encoder = new IntSet(unique);
        int n = category.length;
        int[] y = category;
        if (unique[0] != 0 || unique[m - 1] != m - 1) {
            y = new int[n];
            for (int i = 0; i < n; ++i) {
                y[i] = encoder.indexOf(category[i]);
            }
        }
        int[] ni = new int[m];
        int[] nArray = y;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int i2;
            int n3 = i2 = nArray[i];
            ni[n3] = ni[n3] + 1;
        }
        int[][] strata = new int[m][];
        for (int i = 0; i < m; ++i) {
            strata[i] = new int[ni[i]];
        }
        int[] pos = new int[m];
        int i = 0;
        while (i < n) {
            int j;
            int n4 = j = y[i];
            int n5 = pos[n4];
            pos[n4] = n5 + 1;
            strata[j][n5] = i++;
        }
        return strata;
    }

    public static int[] stratify(int[] category, double subsample) {
        int[][] strata = Sampling.strata(category);
        int n = category.length;
        int m = strata.length;
        if (subsample == 1.0) {
            int[] samples = new int[n];
            int l = 0;
            for (int i = 0; i < m; ++i) {
                int[] stratum = strata[i];
                int size = strata[i].length;
                for (int j = 0; j < size; ++j) {
                    samples[l++] = stratum[MathEx.randomInt(size)];
                }
            }
            return samples;
        }
        int size = 0;
        for (int i = 0; i < m; ++i) {
            size += (int)Math.round(subsample * (double)strata[i].length);
        }
        int[] samples = new int[size];
        int l = 0;
        for (int i = 0; i < m; ++i) {
            int sub = (int)Math.round(subsample * (double)strata[i].length);
            int[] stratum = strata[i];
            int[] permutation = MathEx.permutate(strata[i].length);
            for (int j = 0; j < sub; ++j) {
                samples[l++] = stratum[permutation[j]];
            }
        }
        return samples;
    }

    public static int[][] latin(int n, int d) {
        int[][] hypercube = new int[n][d];
        int[] intervals = MathEx.permutate(n);
        for (int j = 0; j < d; ++j) {
            for (int i = 0; i < n; ++i) {
                hypercube[i][j] = intervals[i];
            }
            MathEx.permutate(intervals);
        }
        return hypercube;
    }
}

