/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.operations.RO_append;
import com.github.fppt.jedismock.operations.RO_blpop;
import com.github.fppt.jedismock.operations.RO_brpop;
import com.github.fppt.jedismock.operations.RO_brpoplpush;
import com.github.fppt.jedismock.operations.RO_decr;
import com.github.fppt.jedismock.operations.RO_decrby;
import com.github.fppt.jedismock.operations.RO_del;
import com.github.fppt.jedismock.operations.RO_exec;
import com.github.fppt.jedismock.operations.RO_exists;
import com.github.fppt.jedismock.operations.RO_expire;
import com.github.fppt.jedismock.operations.RO_expireat;
import com.github.fppt.jedismock.operations.RO_flushall;
import com.github.fppt.jedismock.operations.RO_flushdb;
import com.github.fppt.jedismock.operations.RO_get;
import com.github.fppt.jedismock.operations.RO_getbit;
import com.github.fppt.jedismock.operations.RO_getset;
import com.github.fppt.jedismock.operations.RO_hdel;
import com.github.fppt.jedismock.operations.RO_hexists;
import com.github.fppt.jedismock.operations.RO_hget;
import com.github.fppt.jedismock.operations.RO_hgetall;
import com.github.fppt.jedismock.operations.RO_hkeys;
import com.github.fppt.jedismock.operations.RO_hmget;
import com.github.fppt.jedismock.operations.RO_hmset;
import com.github.fppt.jedismock.operations.RO_hset;
import com.github.fppt.jedismock.operations.RO_hsetnx;
import com.github.fppt.jedismock.operations.RO_incr;
import com.github.fppt.jedismock.operations.RO_incrby;
import com.github.fppt.jedismock.operations.RO_info;
import com.github.fppt.jedismock.operations.RO_keys;
import com.github.fppt.jedismock.operations.RO_lindex;
import com.github.fppt.jedismock.operations.RO_llen;
import com.github.fppt.jedismock.operations.RO_lpop;
import com.github.fppt.jedismock.operations.RO_lpush;
import com.github.fppt.jedismock.operations.RO_lpushx;
import com.github.fppt.jedismock.operations.RO_lrange;
import com.github.fppt.jedismock.operations.RO_lrem;
import com.github.fppt.jedismock.operations.RO_mget;
import com.github.fppt.jedismock.operations.RO_mset;
import com.github.fppt.jedismock.operations.RO_multi;
import com.github.fppt.jedismock.operations.RO_pexpire;
import com.github.fppt.jedismock.operations.RO_pexpireat;
import com.github.fppt.jedismock.operations.RO_pfadd;
import com.github.fppt.jedismock.operations.RO_pfcount;
import com.github.fppt.jedismock.operations.RO_pfmerge;
import com.github.fppt.jedismock.operations.RO_ping;
import com.github.fppt.jedismock.operations.RO_psetex;
import com.github.fppt.jedismock.operations.RO_pttl;
import com.github.fppt.jedismock.operations.RO_publish;
import com.github.fppt.jedismock.operations.RO_quit;
import com.github.fppt.jedismock.operations.RO_rpop;
import com.github.fppt.jedismock.operations.RO_rpoplpush;
import com.github.fppt.jedismock.operations.RO_rpush;
import com.github.fppt.jedismock.operations.RO_sadd;
import com.github.fppt.jedismock.operations.RO_scan;
import com.github.fppt.jedismock.operations.RO_scard;
import com.github.fppt.jedismock.operations.RO_select;
import com.github.fppt.jedismock.operations.RO_set;
import com.github.fppt.jedismock.operations.RO_setbit;
import com.github.fppt.jedismock.operations.RO_setex;
import com.github.fppt.jedismock.operations.RO_setnx;
import com.github.fppt.jedismock.operations.RO_sinter;
import com.github.fppt.jedismock.operations.RO_smembers;
import com.github.fppt.jedismock.operations.RO_spop;
import com.github.fppt.jedismock.operations.RO_srem;
import com.github.fppt.jedismock.operations.RO_sscan;
import com.github.fppt.jedismock.operations.RO_strlen;
import com.github.fppt.jedismock.operations.RO_subscribe;
import com.github.fppt.jedismock.operations.RO_time;
import com.github.fppt.jedismock.operations.RO_ttl;
import com.github.fppt.jedismock.operations.RO_unsubscribe;
import com.github.fppt.jedismock.operations.RO_zadd;
import com.github.fppt.jedismock.operations.RO_zcard;
import com.github.fppt.jedismock.operations.RO_zrange;
import com.github.fppt.jedismock.operations.RO_zrem;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public class OperationFactory {
    private static final Map<String, BiFunction<RedisBase, List<Slice>, RedisOperation>> TRANSACTIONAL_OPERATIONS = new HashMap<String, BiFunction<RedisBase, List<Slice>, RedisOperation>>();

    public static RedisOperation buildTxOperation(RedisBase base, String name, List<Slice> params) {
        BiFunction<RedisBase, List<Slice>, RedisOperation> builder = TRANSACTIONAL_OPERATIONS.get(name);
        if (builder == null) {
            throw new UnsupportedOperationException(String.format("Unsupported operation '%s'", name));
        }
        return builder.apply(base, params);
    }

    public static Optional<RedisOperation> buildMetaOperation(String name, OperationExecutorState state, List<Slice> params) {
        switch (name) {
            case "info": {
                return Optional.of(new RO_info());
            }
            case "multi": {
                return Optional.of(new RO_multi(state));
            }
            case "select": {
                return Optional.of(new RO_select(state, params));
            }
            case "subscribe": {
                return Optional.of(new RO_subscribe(state, params));
            }
            case "unsubscribe": {
                return Optional.of(new RO_unsubscribe(state, params));
            }
            case "quit": {
                return Optional.of(new RO_quit(state));
            }
            case "exec": {
                return Optional.of(new RO_exec(state));
            }
        }
        return Optional.empty();
    }

    static {
        TRANSACTIONAL_OPERATIONS.put("set", RO_set::new);
        TRANSACTIONAL_OPERATIONS.put("setex", RO_setex::new);
        TRANSACTIONAL_OPERATIONS.put("psetex", RO_psetex::new);
        TRANSACTIONAL_OPERATIONS.put("setnx", RO_setnx::new);
        TRANSACTIONAL_OPERATIONS.put("setbit", RO_setbit::new);
        TRANSACTIONAL_OPERATIONS.put("append", RO_append::new);
        TRANSACTIONAL_OPERATIONS.put("get", RO_get::new);
        TRANSACTIONAL_OPERATIONS.put("getbit", RO_getbit::new);
        TRANSACTIONAL_OPERATIONS.put("ttl", RO_ttl::new);
        TRANSACTIONAL_OPERATIONS.put("pttl", RO_pttl::new);
        TRANSACTIONAL_OPERATIONS.put("expire", RO_expire::new);
        TRANSACTIONAL_OPERATIONS.put("pexpire", RO_pexpire::new);
        TRANSACTIONAL_OPERATIONS.put("incr", RO_incr::new);
        TRANSACTIONAL_OPERATIONS.put("incrby", RO_incrby::new);
        TRANSACTIONAL_OPERATIONS.put("decr", RO_decr::new);
        TRANSACTIONAL_OPERATIONS.put("decrby", RO_decrby::new);
        TRANSACTIONAL_OPERATIONS.put("pfcount", RO_pfcount::new);
        TRANSACTIONAL_OPERATIONS.put("pfadd", RO_pfadd::new);
        TRANSACTIONAL_OPERATIONS.put("pfmerge", RO_pfmerge::new);
        TRANSACTIONAL_OPERATIONS.put("mget", RO_mget::new);
        TRANSACTIONAL_OPERATIONS.put("mset", RO_mset::new);
        TRANSACTIONAL_OPERATIONS.put("getset", RO_getset::new);
        TRANSACTIONAL_OPERATIONS.put("strlen", RO_strlen::new);
        TRANSACTIONAL_OPERATIONS.put("del", RO_del::new);
        TRANSACTIONAL_OPERATIONS.put("exists", RO_exists::new);
        TRANSACTIONAL_OPERATIONS.put("expireat", RO_expireat::new);
        TRANSACTIONAL_OPERATIONS.put("pexpireat", RO_pexpireat::new);
        TRANSACTIONAL_OPERATIONS.put("lpush", RO_lpush::new);
        TRANSACTIONAL_OPERATIONS.put("rpush", RO_rpush::new);
        TRANSACTIONAL_OPERATIONS.put("lpushx", RO_lpushx::new);
        TRANSACTIONAL_OPERATIONS.put("lrange", RO_lrange::new);
        TRANSACTIONAL_OPERATIONS.put("llen", RO_llen::new);
        TRANSACTIONAL_OPERATIONS.put("lpop", RO_lpop::new);
        TRANSACTIONAL_OPERATIONS.put("rpop", RO_rpop::new);
        TRANSACTIONAL_OPERATIONS.put("lindex", RO_lindex::new);
        TRANSACTIONAL_OPERATIONS.put("rpoplpush", RO_rpoplpush::new);
        TRANSACTIONAL_OPERATIONS.put("brpoplpush", RO_brpoplpush::new);
        TRANSACTIONAL_OPERATIONS.put("publish", RO_publish::new);
        TRANSACTIONAL_OPERATIONS.put("flushall", RO_flushall::new);
        TRANSACTIONAL_OPERATIONS.put("flushdb", RO_flushdb::new);
        TRANSACTIONAL_OPERATIONS.put("lrem", RO_lrem::new);
        TRANSACTIONAL_OPERATIONS.put("ping", RO_ping::new);
        TRANSACTIONAL_OPERATIONS.put("keys", RO_keys::new);
        TRANSACTIONAL_OPERATIONS.put("sadd", RO_sadd::new);
        TRANSACTIONAL_OPERATIONS.put("scan", RO_scan::new);
        TRANSACTIONAL_OPERATIONS.put("sscan", RO_sscan::new);
        TRANSACTIONAL_OPERATIONS.put("spop", RO_spop::new);
        TRANSACTIONAL_OPERATIONS.put("srem", RO_srem::new);
        TRANSACTIONAL_OPERATIONS.put("scard", RO_scard::new);
        TRANSACTIONAL_OPERATIONS.put("hexists", RO_hexists::new);
        TRANSACTIONAL_OPERATIONS.put("hget", RO_hget::new);
        TRANSACTIONAL_OPERATIONS.put("hset", RO_hset::new);
        TRANSACTIONAL_OPERATIONS.put("hdel", RO_hdel::new);
        TRANSACTIONAL_OPERATIONS.put("hkeys", RO_hkeys::new);
        TRANSACTIONAL_OPERATIONS.put("hgetall", RO_hgetall::new);
        TRANSACTIONAL_OPERATIONS.put("sinter", RO_sinter::new);
        TRANSACTIONAL_OPERATIONS.put("hmget", RO_hmget::new);
        TRANSACTIONAL_OPERATIONS.put("hmset", RO_hmset::new);
        TRANSACTIONAL_OPERATIONS.put("smembers", RO_smembers::new);
        TRANSACTIONAL_OPERATIONS.put("hsetnx", RO_hsetnx::new);
        TRANSACTIONAL_OPERATIONS.put("time", RO_time::new);
        TRANSACTIONAL_OPERATIONS.put("blpop", RO_blpop::new);
        TRANSACTIONAL_OPERATIONS.put("brpop", RO_brpop::new);
        TRANSACTIONAL_OPERATIONS.put("zadd", RO_zadd::new);
        TRANSACTIONAL_OPERATIONS.put("zcard", RO_zcard::new);
        TRANSACTIONAL_OPERATIONS.put("zrange", RO_zrange::new);
        TRANSACTIONAL_OPERATIONS.put("zrem", RO_zrem::new);
    }
}

