/*
 * Decompiled with CFR 0.152.
 */
package marvin.util;

public class MarvinStringParser {
    private int currPosition;
    private String data;

    public MarvinStringParser(String s) {
        this.data = s;
        this.currPosition = 0;
    }

    public int getCurrentPosition() {
        return this.currPosition;
    }

    public void incPosition(int inc) {
        this.currPosition += inc;
    }

    public String getNext(char[] suffixes) {
        int idx = this.indexOf(suffixes, this.data, this.currPosition);
        if (idx != -1) {
            String ret = this.data.substring(this.currPosition, idx).trim();
            this.currPosition = idx;
            return ret;
        }
        return null;
    }

    public String getNextBetween(String prefix, String suffix) {
        int idx1 = this.data.indexOf(prefix, this.currPosition);
        int idx2 = this.data.indexOf(suffix, this.currPosition);
        if (idx1 != -1 && idx2 != -1) {
            this.currPosition = idx2;
            return this.data.substring(idx1 + prefix.length(), idx2);
        }
        return null;
    }

    public boolean hasBefore(String text, String suffix) {
        int idx = this.data.indexOf(suffix, this.currPosition);
        if (idx != -1) {
            String sub = this.data.substring(this.currPosition, idx);
            return sub.indexOf(text) != -1;
        }
        return false;
    }

    public String getCurrentLine() {
        int idx = this.data.indexOf(10, this.currPosition);
        if (idx != -1) {
            return this.data.substring(this.currPosition, idx);
        }
        return null;
    }

    public boolean gotoNextLine() {
        int idx = this.data.indexOf("\n", this.currPosition);
        if (idx != -1) {
            this.currPosition = idx + 1;
            return true;
        }
        return false;
    }

    public int countTextBefore(String text, String suffix) {
        int idx = this.data.indexOf(suffix, this.currPosition);
        if (idx != -1) {
            String sub = this.data.substring(this.currPosition, idx);
            sub = sub.replace("#", "");
            sub = sub.replace(text, "#");
            return this.count('#', sub);
        }
        return -1;
    }

    public void jumpOver(char[] arr) {
        for (int i = this.currPosition; i < this.data.length(); ++i) {
            if (this.inArr(this.data.charAt(i), arr)) continue;
            this.currPosition = i;
            break;
        }
    }

    private boolean inArr(char achar, char[] arr) {
        for (char c : arr) {
            if (c != achar) continue;
            return true;
        }
        return false;
    }

    private int indexOf(char[] arr, String content, int pos) {
        for (int i = pos; i < content.length(); ++i) {
            if (!this.inArr(content.charAt(i), arr)) continue;
            return i;
        }
        return -1;
    }

    private int count(char c, String s) {
        int total = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++total;
        }
        return total;
    }
}

