/*
 * Decompiled with CFR 0.152.
 */
package marvin.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import marvin.image.MarvinImage;
import marvin.util.MarvinAttributes;
import marvin.util.MarvinFileChooser;

public class MarvinPluginHistory
extends JFrame {
    private static final int TOP_MARGIN = 50;
    private static final int BOTTOM_MARGIN = 10;
    private static final int ATTRIBUTES_MARGIN = 200;
    private static final int THUMBNAIL_WIDTH = 200;
    private static final String STORE_SUCCESS = "History exported sucessfully";
    private static final String STORE_FAILED = "Error while exporting the history";
    JPanel panelButtonHistory;
    JButton buttonExportHistortAsImage;
    JButton buttonExportHistoryAsImage;
    JPanel panelPlugin;
    JScrollPane scrollPanelPlugins;
    private LinkedList<String> listPluginName;
    private LinkedList<MarvinImage> listMarvinImage;
    private LinkedList<MarvinAttributes> listMarvinAttributes;
    private JFrame frameHistory = this;

    public MarvinPluginHistory() {
        this.setLayout(new BorderLayout());
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setTitle("Plug-ins history");
        this.listMarvinImage = new LinkedList();
        this.listMarvinAttributes = new LinkedList();
        this.listPluginName = new LinkedList();
        this.panelPlugin = new JPanel();
        this.scrollPanelPlugins = new JScrollPane(this.panelPlugin, 21, 30);
        this.scrollPanelPlugins.setLayout(new ScrollPaneLayout());
        this.add(this.scrollPanelPlugins);
        this.panelButtonHistory = new JPanel();
        this.buttonExportHistortAsImage = new JButton("Export as Image");
        this.buttonExportHistortAsImage.addActionListener(new ExportButtonHandler());
        this.buttonExportHistortAsImage.setMnemonic('I');
        this.panelButtonHistory.add(this.buttonExportHistortAsImage);
        this.add((Component)this.panelButtonHistory, "Last");
    }

    public void addEntry(String plgName, MarvinImage img, MarvinAttributes attr) {
        this.listPluginName.add(plgName);
        MarvinImage l_image = null;
        MarvinAttributes l_attributes = null;
        if (img != null) {
            l_image = img.clone();
        }
        if (attr != null) {
            l_attributes = attr.clone();
        }
        this.listMarvinImage.add(l_image);
        this.listMarvinAttributes.add(l_attributes);
    }

    public void showThumbnailHistory() {
        this.panelPlugin.removeAll();
        this.panelPlugin.setLayout(new GridLayout(1, this.listMarvinImage.size()));
        for (int l_pos = 0; l_pos < this.listMarvinImage.size(); ++l_pos) {
            String l_name = this.listPluginName.get(l_pos);
            MarvinImage l_image = this.listMarvinImage.get(l_pos);
            MarvinAttributes l_pluginAttributes = this.listMarvinAttributes.get(l_pos);
            JLabel l_labelIcon = new JLabel(new ImageIcon(l_image.getBufferedImage(200, 200)));
            TextArea l_textPluginInfo = new TextArea("", 5, 25, 1);
            l_textPluginInfo.setEditable(false);
            l_textPluginInfo.append(l_name + "\n\n");
            if (l_pluginAttributes != null) {
                if (l_pluginAttributes.toStringArray().length > 0) {
                    l_textPluginInfo.append("Attributes:\n");
                }
                for (int j = 0; j < l_pluginAttributes.toStringArray().length; j += 2) {
                    l_textPluginInfo.append(l_pluginAttributes.toStringArray()[j] + ": ");
                    l_textPluginInfo.append(l_pluginAttributes.toStringArray()[j + 1] + "\n");
                }
            }
            JPanel l_panelPlugin = new JPanel();
            l_panelPlugin.add(l_labelIcon);
            l_panelPlugin.add(l_textPluginInfo);
            this.panelPlugin.add(l_panelPlugin);
        }
        this.panelPlugin.setPreferredSize(new Dimension(this.listMarvinImage.size() * 220, 350));
        int l_windowWidth = this.listMarvinImage.size() * 220;
        if (l_windowWidth > 1024) {
            l_windowWidth = 1024;
        }
        this.setSize(l_windowWidth, 430);
        this.setVisible(true);
    }

    public void clear() {
        this.listPluginName = new LinkedList();
        this.listMarvinImage = new LinkedList();
        this.listMarvinAttributes = new LinkedList();
    }

    private void exportAsImage() {
        System.out.println("listMarvinImage.size():" + this.listMarvinImage.size());
        System.out.println("listMarvinAttributes.size():" + this.listMarvinAttributes.size());
        try {
            String[] l_attributesAsString = null;
            int l_imagePx = 5;
            int l_attributePy = 0;
            int width = 0;
            int height = 0;
            for (MarvinImage img : this.listMarvinImage) {
                width += img.getWidth() + 200;
                if (img.getHeight() <= height) continue;
                height = img.getHeight();
            }
            height += 60;
            String arq = MarvinFileChooser.select(this.frameHistory, false, 1);
            if (arq != null) {
                BufferedImage bufExport = new BufferedImage(width + 5, height, this.listMarvinImage.get(0).getType());
                Graphics2D g = bufExport.createGraphics();
                height = this.listMarvinImage.get(0).getHeight();
                for (int l_pos = 0; l_pos < this.listMarvinImage.size(); ++l_pos) {
                    String l_pluginName = this.listPluginName.get(l_pos);
                    MarvinImage l_image = this.listMarvinImage.get(l_pos);
                    MarvinAttributes l_attributes = this.listMarvinAttributes.get(l_pos);
                    if (l_attributes != null) {
                        l_attributesAsString = l_attributes.toStringArray();
                    }
                    g.drawImage(l_image.getBufferedImage(), null, l_imagePx, 50);
                    g.setColor(Color.white);
                    g.drawRect(l_imagePx + l_image.getWidth() + 5, 50, 190, l_image.getHeight());
                    if (l_pluginName.lastIndexOf(46) != -1) {
                        g.drawString(l_pluginName.substring(l_pluginName.lastIndexOf(46) + 1, l_pluginName.length()), l_imagePx + l_image.getWidth() + 10, 65);
                    } else {
                        g.drawString(l_pluginName, l_imagePx + l_image.getWidth() + 10, 65);
                    }
                    g.drawString("ATTRIBUTES:", l_imagePx + l_image.getWidth() + 10, 95);
                    l_attributePy = 125;
                    if (l_attributes != null) {
                        g.setColor(Color.white);
                        for (int i = 0; i < l_attributesAsString.length; i += 2) {
                            g.drawString(l_attributesAsString[i] + ": " + l_attributesAsString[i + 1], l_imagePx + l_image.getWidth() + 10, l_attributePy);
                            l_attributePy += 15;
                        }
                    }
                    l_imagePx += l_image.getWidth() + 200;
                }
                g.setFont(new Font("Courier", 1, 30));
                g.drawString("Marvin 1.2 - Plug-ins history", 5, 30);
                g.dispose();
                if (ImageIO.write((RenderedImage)bufExport, "jpg", new File(arq))) {
                    JOptionPane.showMessageDialog(this.frameHistory, STORE_SUCCESS);
                } else {
                    JOptionPane.showMessageDialog(this.frameHistory, STORE_FAILED);
                }
                this.frameHistory.setVisible(false);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private class ExportButtonHandler
    implements ActionListener {
        private ExportButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MarvinPluginHistory.this.buttonExportHistortAsImage) {
                MarvinPluginHistory.this.exportAsImage();
            }
        }
    }
}

