/*
 * Decompiled with CFR 0.152.
 */
package marvin.util;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MarvinFileChooser
extends JDialog {
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    static JFileChooser chooser = null;
    public static final FileNameExtensionFilter[] JPG = new FileNameExtensionFilter[]{new FileNameExtensionFilter("JPEG", "jpg", "jpg")};
    public static final FileNameExtensionFilter[] PNG = new FileNameExtensionFilter[]{new FileNameExtensionFilter("PNG", "png")};
    public static final FileNameExtensionFilter[] AllSupportedImages = new FileNameExtensionFilter[]{JPG[0], PNG[0]};

    private static void init() {
        chooser = new JFileChooser("./img");
        chooser.setAcceptAllFileFilterUsed(false);
    }

    public static String select(String directory, Component parent, boolean forceExistingFile, int dialogType, FileNameExtensionFilter[] arrExtensions) throws IOException {
        int lastIndex;
        int res = 0;
        if (chooser == null) {
            MarvinFileChooser.init();
        }
        if (arrExtensions == null) {
            chooser.resetChoosableFileFilters();
        } else {
            for (int i = 0; i < arrExtensions.length; ++i) {
                chooser.addChoosableFileFilter(arrExtensions[i]);
            }
        }
        if (directory != null) {
            chooser.setCurrentDirectory(new File(directory));
        }
        switch (dialogType) {
            case 0: {
                res = chooser.showOpenDialog(parent);
                break;
            }
            case 1: {
                res = chooser.showSaveDialog(parent);
            }
        }
        if (res == 1) {
            MarvinFileChooser.init();
            return null;
        }
        if (chooser.getSelectedFile() == null) {
            throw new FileNotFoundException();
        }
        String path = chooser.getSelectedFile().getCanonicalPath();
        if (dialogType == 1 && (lastIndex = path.lastIndexOf(46)) == -1) {
            path = path + "." + chooser.getFileFilter().getDescription().toLowerCase();
        }
        if (path != null) {
            if (forceExistingFile && !chooser.getSelectedFile().exists()) {
                throw new FileNotFoundException();
            }
            MarvinFileChooser.init();
            return path;
        }
        throw new FileNotFoundException();
    }

    public static String select(Component parent, boolean forceExistingFile, int dialogType) throws IOException {
        return MarvinFileChooser.select(null, parent, forceExistingFile, dialogType, AllSupportedImages);
    }

    public static String select(String directory, Component parent, boolean forceExistingFile, int dialogType) throws IOException {
        return MarvinFileChooser.select(directory, parent, forceExistingFile, dialogType, AllSupportedImages);
    }

    public static String select(Component parent, boolean forceExistingFile, int dialogType, FileNameExtensionFilter[] arrExtensions) throws IOException {
        return MarvinFileChooser.select(null, parent, forceExistingFile, dialogType, arrExtensions);
    }
}

