/*
 * Decompiled with CFR 0.152.
 */
package marvin.thread;

import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinImagePlugin;
import marvin.plugin.MarvinPlugin;
import marvin.thread.MarvinThreadEvent;
import marvin.thread.MarvinThreadListener;

public class MarvinThread
implements Runnable {
    private static long currentId = 0L;
    private long id = currentId++;
    private MarvinThreadListener listener;
    private Thread thread;
    private MarvinPlugin plugin;
    private MarvinImage imageIn;
    private MarvinImage imageOut;
    private MarvinImageMask imageMask;
    PluginType eType;

    public MarvinThread(MarvinImagePlugin plg, MarvinImage imgIn, MarvinImage imgOut, MarvinImageMask mask) {
        this.plugin = plg;
        this.imageIn = imgIn;
        this.imageOut = imgOut;
        this.imageMask = mask;
        this.eType = PluginType.PLUGIN_IMAGE;
        this.thread = new Thread(this);
    }

    public long getId() {
        return this.id;
    }

    public void start() {
        this.thread.start();
    }

    public void addThreadListener(MarvinThreadListener l) {
        this.listener = l;
    }

    @Override
    public void run() {
        switch (this.eType) {
            case PLUGIN_IMAGE: {
                ((MarvinImagePlugin)this.plugin).process(this.imageIn, this.imageOut, null, this.imageMask, false);
                if (this.listener == null) break;
                this.listener.threadFinished(new MarvinThreadEvent(this.id, this.plugin));
            }
        }
    }

    private static enum PluginType {
        PLUGIN_IMAGE;

    }
}

