/*
 * Decompiled with CFR 0.152.
 */
package marvin.statistic;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import marvin.statistic.MarvinHistogramEntry;

public class MarvinHistogram {
    private String description;
    private double maxX;
    private double maxY;
    private int barWidth;
    private Hashtable<Integer, MarvinHistogramEntry> hashEntries;
    private int[] arrPaintedColumns;

    public MarvinHistogram(String a_description) {
        this.description = a_description;
        this.hashEntries = new Hashtable();
        this.maxX = 0.0;
        this.maxY = 0.0;
    }

    public void setBarWidth(int barW) {
        this.barWidth = barW;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void addEntry(MarvinHistogramEntry entry) {
        this.hashEntries.put(entry.hashCode(), entry);
        if (entry.getValueX() > this.maxX) {
            this.maxX = entry.getValueX();
        }
        if (entry.getValueY() > this.maxY) {
            this.maxY = entry.getValueY();
        }
    }

    public void draw(int px, int py, int width, int height, Graphics g) {
        g.setColor(Color.white);
        g.fillRect(px, py, width, height);
        g.setColor(Color.black);
        g.drawString(this.description, (int)((double)width * 0.05), py + 12);
        this.drawHisto(px + (int)((double)width * 0.05), py + (int)((double)height * 0.1), (int)((double)width * 0.95), (int)((double)height * 0.8), g);
        g.setColor(Color.black);
        g.drawLine(px + (int)((double)width * 0.05), py + (int)((double)height * 0.1), px + (int)((double)width * 0.05), (int)((double)height * 0.9));
        g.drawLine(px + (int)((double)width * 0.05), (int)((double)height * 0.9), width, (int)((double)height * 0.9));
    }

    private void drawHisto(int px, int py, int width, int height, Graphics g) {
        MarvinHistogramEntry l_entry;
        this.arrPaintedColumns = new int[width + 1];
        Enumeration<MarvinHistogramEntry> e = this.hashEntries.elements();
        while (e.hasMoreElements()) {
            l_entry = e.nextElement();
            this.drawEntry(px + 2, py, width - 2, height, l_entry, g);
        }
        for (int i = 0; i < width; ++i) {
            if (this.arrPaintedColumns[i] != 0 || i <= 0) continue;
            l_entry = this.hashEntries.get(this.arrPaintedColumns[i - 1]);
            this.redrawEntry(px + 2, i, py, height, l_entry, g);
        }
    }

    private void drawEntry(int px, int py, int width, int height, MarvinHistogramEntry entry, Graphics g) {
        if (entry.getColor() != null) {
            g.setColor(entry.getColor());
        } else {
            g.setColor(Color.black);
        }
        int l_ePx = (int)((double)width * (entry.getValueX() / this.maxX));
        int l_eHeight = (int)((double)height * (entry.getValueY() / this.maxY));
        g.fillRect(px + l_ePx, py + height - l_eHeight, this.barWidth, l_eHeight);
        this.arrPaintedColumns[l_ePx] = entry.hashCode();
    }

    private void redrawEntry(int pxHisto, int pxEntry, int py, int height, MarvinHistogramEntry entry, Graphics g) {
        if (entry.getColor() != null) {
            g.setColor(entry.getColor());
        } else {
            g.setColor(Color.black);
        }
        int l_eHeight = (int)((double)height * (entry.getValueY() / this.maxY));
        g.fillRect(pxHisto + pxEntry, py + height - l_eHeight, this.barWidth, l_eHeight);
        this.arrPaintedColumns[pxEntry] = entry.hashCode();
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage l_buf = new BufferedImage(width, height, 1);
        Graphics2D l_g2d = (Graphics2D)l_buf.getGraphics();
        l_g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.draw(0, 0, width, height, l_g2d);
        return l_buf;
    }
}

