/*
 * Decompiled with CFR 0.152.
 */
package marvin.statistic;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import marvin.statistic.MarvinBarChartEntry;

public class MarvinBarChart {
    public static final int ORIGINAL_BAR_COLOR = 0;
    public static final int SEQUENTIAL_BAR_COLOR = 1;
    private static final int BAR_REFERENCE_HEIGHT = 15;
    private static final int CHARACTER_WIDTH = 8;
    private static final int CHARACTER_HEIGHT = 15;
    private static final Color[] BAR_COLORS = new Color[]{Color.blue, Color.red, new Color(0, 125, 0), Color.orange, Color.green, Color.pink, Color.cyan, Color.yellow};
    private String description;
    private int barsColorType;
    private double maxValue;
    private double maxHeight;
    private LinkedList<MarvinBarChartEntry> listEntries;

    public MarvinBarChart(String desc) {
        this.description = desc;
        this.barsColorType = 0;
        this.maxValue = 0.0;
        this.maxHeight = 0.0;
        this.listEntries = new LinkedList();
    }

    public void addEntry(MarvinBarChartEntry entry) {
        this.listEntries.add(entry);
        if (entry.getValue() > this.maxValue) {
            this.maxValue = entry.getValue();
            this.maxHeight = entry.getValue() - 15.0;
        }
    }

    public void setBarsColor(int type) {
        this.barsColorType = type;
    }

    private Color getBarColor(MarvinBarChartEntry entry, int barIndex) {
        switch (this.barsColorType) {
            case 0: {
                return entry.getColor();
            }
            case 1: {
                return BAR_COLORS[barIndex % BAR_COLORS.length];
            }
        }
        return null;
    }

    public void draw(int px, int py, int width, int height, Graphics graphics) {
        int chartLeftDistance = ("" + this.maxValue).length() * 8 + 5;
        graphics.setColor(Color.white);
        graphics.fillRect(px, py, width, height);
        graphics.setColor(Color.black);
        graphics.drawString(this.description, chartLeftDistance, 12);
        this.drawChart(px + chartLeftDistance, py + (int)((double)height * 0.1), width - chartLeftDistance, (int)((double)height * 0.6), graphics);
        this.drawBarReference(px + chartLeftDistance, (int)((double)height * 0.75), width - chartLeftDistance, (int)((double)height * 0.25), graphics);
        this.drawIntervals(px + chartLeftDistance, py + (int)((double)height * 0.1), width - chartLeftDistance, (int)((double)height * 0.6), graphics);
    }

    private void drawChart(int px, int py, int width, int height, Graphics g) {
        g.setColor(Color.black);
        g.drawLine(px, py + height, px + width, py + height);
        g.drawLine(px, py, px, py + height);
        Object[] arrEntries = this.listEntries.toArray();
        int l_numEntries = this.listEntries.size();
        int barWidth = (int)((double)width * 0.7 / (double)l_numEntries);
        int barDistance = (int)((double)width * 0.3 / (double)(l_numEntries + 1));
        for (int i = 0; i < l_numEntries; ++i) {
            MarvinBarChartEntry entry = (MarvinBarChartEntry)arrEntries[i];
            g.setColor(this.getBarColor(entry, i));
            int l_height = (int)((double)height * (entry.getValue() / this.maxHeight));
            if (l_height == 0 && entry.getValue() > 0.0) {
                l_height = 1;
            }
            int l_px = px + (barDistance + (barDistance + barWidth) * i);
            int l_py = py + (height - l_height);
            g.fillRect(l_px, l_py, barWidth, l_height);
            g.setColor(Color.black);
        }
    }

    private void drawBarReference(int px, int py, int width, int height, Graphics g) {
        int l_py = py;
        int l_px = px;
        int l_barReferenceWidth = width / 3;
        int l_barReferenceStringLength = (l_barReferenceWidth - 12) / 8;
        Object[] arrEntries = this.listEntries.toArray();
        int l_numEntries = this.listEntries.size();
        for (int i = 0; i < l_numEntries; ++i) {
            MarvinBarChartEntry entry = (MarvinBarChartEntry)arrEntries[i];
            l_px = px + i * l_barReferenceWidth % width;
            l_py = py + i * l_barReferenceWidth / width * 15;
            g.setColor(this.getBarColor(entry, i));
            g.fillRect(l_px, l_py, 10, 10);
            g.setColor(Color.black);
            if (entry.getName().length() > l_barReferenceStringLength) {
                g.drawString(entry.getName().substring(0, l_barReferenceStringLength) + ".", l_px + 12, l_py + 10);
                continue;
            }
            g.drawString(entry.getName(), l_px + 12, l_py + 10);
        }
    }

    private void drawIntervals(int px, int py, int width, int height, Graphics g) {
        int intervalMaxValue = (int)(this.maxValue / 10.0) * 10;
        double numIntervals = height / 30;
        double intervalHeight = (double)height / numIntervals;
        int intervalValue = (int)((double)intervalMaxValue / numIntervals);
        int l_value = intervalMaxValue;
        g.setColor(Color.black);
        int i = 0;
        while ((double)i < numIntervals + 1.0) {
            int l_py;
            if ((double)i == numIntervals) {
                l_py = py + height;
                l_value = 0;
            } else {
                l_py = py + (int)((double)i * intervalHeight);
            }
            g.drawLine(px, l_py, px - 5, l_py);
            g.drawString("" + l_value, px - 5 - ("" + l_value).length() * 8, l_py);
            l_value -= intervalValue;
            ++i;
        }
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage l_buf = new BufferedImage(width, height, 1);
        Graphics2D l_g2d = (Graphics2D)l_buf.getGraphics();
        l_g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.draw(0, 0, width, height, l_g2d);
        return l_buf;
    }
}

