/*
 * Decompiled with CFR 0.152.
 */
package marvin.performance;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import marvin.performance.MarvinPerformanceEntry;
import marvin.performance.MarvinPerformanceRegistry;
import marvin.performance.MarvinPerformanceWindow;

public class MarvinPerformanceMeter
implements Runnable {
    private JPanel panel;
    private JLabel labelTime;
    private JProgressBar progressBar;
    private JButton buttonStats;
    private MarvinPerformanceRegistry performanceRegistry = new MarvinPerformanceRegistry();
    private MarvinPerformanceEntry currentPerformanceEntry;
    private boolean processFinished;
    private int progressValue;
    private boolean haveStats;
    private boolean finishProcess;
    private boolean enabled;

    public JPanel getPanel() {
        return this.panel;
    }

    public MarvinPerformanceRegistry getRegistry() {
        return this.performanceRegistry;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void reset() {
        if (this.enabled) {
            this.performanceRegistry = new MarvinPerformanceRegistry();
            this.progressBar.setString("");
            this.progressBar.setStringPainted(true);
            this.labelTime.setText("");
            this.buttonStats.setEnabled(false);
            this.haveStats = false;
            this.finishProcess = false;
            this.enabled = true;
        }
    }

    public void start(String a_name) {
        this.start(a_name, a_name);
    }

    public void start(String a_id, String a_name) {
        if (this.enabled) {
            this.currentPerformanceEntry = new MarvinPerformanceEntry(a_id, a_name);
            this.performanceRegistry.addEntry(this.currentPerformanceEntry);
            this.processFinished = false;
            this.haveStats = false;
            this.finishProcess = false;
        }
    }

    public void enableProgressBar(String a_text, int a_steps) {
        if (this.enabled) {
            this.processFinished = false;
            this.finishProcess = false;
            this.progressValue = 0;
            this.progressBar.setString(a_text);
            this.progressBar.setStringPainted(true);
            this.progressBar.setMaximum(a_steps);
            new Thread(this).start();
        }
    }

    public void incProgressBar() {
        this.incProgressBar(1);
    }

    public void incProgressBar(int a_inc) {
        if (this.enabled) {
            this.progressValue += a_inc;
        }
    }

    public void startEvent(String a_name) {
        this.startEvent(a_name, a_name);
    }

    public void startEvent(String a_id, String a_name) {
        if (this.enabled) {
            this.currentPerformanceEntry.startEvent(a_id, a_name);
            this.haveStats = true;
        }
    }

    public void finishEvent() {
        if (this.enabled && this.currentPerformanceEntry != null) {
            this.currentPerformanceEntry.finishEvent();
        }
    }

    public void finish() {
        if (this.enabled) {
            this.labelTime.setText("Total time: " + this.performanceRegistry.getTotalTime() + " milliseconds");
            this.progressBar.setValue(0);
            this.finishProcess = true;
            if (this.haveStats) {
                this.buttonStats.setEnabled(true);
            }
        }
    }

    public void stepFinished() {
        if (this.enabled && this.currentPerformanceEntry != null) {
            this.currentPerformanceEntry.stepFinished();
        }
    }

    public void stepsFinished(int a_steps) {
        if (this.enabled && this.currentPerformanceEntry != null) {
            this.currentPerformanceEntry.stepsFinished(a_steps);
        }
    }

    @Override
    public void run() {
        while (!this.processFinished) {
            try {
                this.progressBar.setValue(this.progressValue);
                this.progressBar.getUI().update(this.progressBar.getGraphics(), this.progressBar);
                Thread.sleep(200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.finishProcess) continue;
            this.processFinished = true;
        }
    }

    public void showStats() {
        new MarvinPerformanceWindow(this.performanceRegistry);
    }
}

