/*
 * Decompiled with CFR 0.152.
 */
package marvin.machinelearning.decisiontree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DecisionTreeNode {
    private String attr;
    private CONDITION condition;
    private Object value;
    private String result;
    private boolean root;
    private DecisionTreeNode parent;
    private List<DecisionTreeNode> childs;

    public DecisionTreeNode(String attr, String condition, Object value) {
        this.attr = attr;
        this.condition = this.getCondition(condition);
        this.value = value;
        this.childs = new ArrayList<DecisionTreeNode>();
    }

    private DecisionTreeNode() {
        this(null, null, null);
        this.root = true;
    }

    public static DecisionTreeNode createRootNode() {
        return new DecisionTreeNode();
    }

    public DecisionTreeNode getParent() {
        return this.parent;
    }

    private CONDITION getCondition(String cond) {
        if ("<".equals(cond)) {
            return CONDITION.LT;
        }
        if ("<=".equals(cond)) {
            return CONDITION.LTE;
        }
        if (">".equals(cond)) {
            return CONDITION.GT;
        }
        if (">=".equals(cond)) {
            return CONDITION.GTE;
        }
        if ("=".equals(cond)) {
            return CONDITION.EQ;
        }
        if ("!=".equals(cond)) {
            return CONDITION.NEQ;
        }
        return null;
    }

    public void addChild(DecisionTreeNode node) {
        this.childs.add(node);
        node.parent = this;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int currLvl) {
        String ret = null;
        ret = this.root ? "[ROOT]\n" : this.pp("---", currLvl) + "Node(" + this.attr + "," + this.condition.toString() + "," + this.value + ")\n";
        for (DecisionTreeNode n : this.childs) {
            ret = ret + n.toString(currLvl + 1);
        }
        return ret;
    }

    private String pp(String text, int times) {
        String ret = "";
        for (int i = 0; i < times; ++i) {
            ret = ret + text;
        }
        return ret;
    }

    public String interpret(Map<String, Object> map) {
        if (this.attr != null) {
            if (this.eval(this.attr, map)) {
                if (this.result != null) {
                    return this.result;
                }
                return this.interpretChilds(map);
            }
            return null;
        }
        return this.interpretChilds(map);
    }

    public String interpretChilds(Map<String, Object> map) {
        for (DecisionTreeNode n : this.childs) {
            String ret = n.interpret(map);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean eval(String attr, Map<String, Object> map) {
        Object sValue = map.get(attr);
        if (sValue == null) {
            throw new RuntimeException(attr + " is null");
        }
        if (this.isNumber(sValue)) {
            return this.evalNumeric(attr, sValue);
        }
        return this.evalText(attr, sValue);
    }

    private boolean evalNumeric(String attr, Object sValue) {
        Double n1 = this.getNumeric(sValue);
        Double n2 = (Double)this.value;
        switch (this.condition) {
            case EQ: {
                return n1 == n2;
            }
            case GTE: {
                return n1 >= n2;
            }
            case GT: {
                return n1 > n2;
            }
            case LT: {
                return n1 < n2;
            }
            case LTE: {
                return n1 <= n2;
            }
            case NEQ: {
                return n1 != n2;
            }
        }
        return false;
    }

    private boolean evalText(String attr, Object sValue) {
        String s1 = sValue.toString().trim();
        String s2 = ((String)this.value).trim();
        return s1.equals(s2);
    }

    private Double getNumeric(Object sValue) {
        if (sValue.getClass() == Double.class) {
            return (Double)sValue;
        }
        if (sValue.getClass() == Integer.class) {
            return ((Integer)sValue).doubleValue();
        }
        if (sValue.getClass() == Float.class) {
            return ((Float)sValue).doubleValue();
        }
        return null;
    }

    private boolean isNumber(Object obj) {
        return obj instanceof Integer || obj instanceof Double || obj instanceof Float;
    }

    public static enum CONDITION {
        GT,
        GTE,
        LT,
        LTE,
        EQ,
        NEQ;

    }
}

