/*
 * Decompiled with CFR 0.152.
 */
package marvin.image;

public class MarvinImageMap {
    private int[][] arrMap;
    private int width;
    private int height;

    public MarvinImageMap() {
        this.arrMap = null;
    }

    public MarvinImageMap(int w, int h) {
        this.width = w;
        this.height = h;
        this.arrMap = new int[this.width][this.height];
    }

    public MarvinImageMap(int[][] mask) {
        this.arrMap = mask;
        this.width = this.arrMap[0].length;
        this.height = this.arrMap.length;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setPixel(int x, int y, int value) {
        this.arrMap[x][y] = value;
    }

    public void removePixel(int x, int y, int value) {
        this.arrMap[x][y] = 0;
    }

    public int value(int x, int y) {
        return this.arrMap[x][y];
    }

    public void clear() {
        if (this.arrMap != null) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.arrMap[x][y] = 0;
                }
            }
        }
    }

    public int[][] getMask() {
        return this.arrMap;
    }

    public void addRectRegion(int startX, int startY, int regionWidth, int regionHeight, int value) {
        for (int x = startX; x < startX + regionWidth; ++x) {
            for (int y = startY; y < startY + regionHeight; ++y) {
                this.arrMap[x][y] = value;
            }
        }
    }
}

