/*
 * Decompiled with CFR 0.152.
 */
package marvin.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import marvin.gui.MarvinImagePanel;
import marvin.plugin.MarvinToolPlugin;

public class MarvinToolPanel
extends JPanel {
    private static final int MAX_TOOLS = 50;
    private JButton[] arrButtons;
    private MarvinImagePanel currentImagePanel;
    private MarvinToolPlugin[] arrTools = new MarvinToolPlugin[50];
    private int toolCounter = 0;
    private int currentTool = 0;
    private ButtonHandler buttonHandler;

    public MarvinToolPanel() {
        this.arrButtons = new JButton[50];
        this.buttonHandler = new ButtonHandler();
    }

    public void setImagePanel(MarvinImagePanel ip) {
        if (this.currentImagePanel != ip) {
            this.currentImagePanel = ip;
        }
    }

    public void addTool(MarvinToolPlugin tp) {
        this.arrTools[this.toolCounter] = tp;
        this.arrButtons[this.toolCounter] = new JButton(tp.getIcon());
        this.arrButtons[this.toolCounter].setPreferredSize(new Dimension(tp.getIcon().getImage().getWidth(null) + 10, tp.getIcon().getImage().getHeight(null) + 10));
        this.arrButtons[this.toolCounter].addActionListener(this.buttonHandler);
        this.add(this.arrButtons[this.toolCounter]);
        ++this.toolCounter;
    }

    public MarvinToolPlugin getCurrentTool() {
        return this.arrTools[this.currentTool];
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < MarvinToolPanel.this.toolCounter; ++i) {
                if (event.getSource() != MarvinToolPanel.this.arrButtons[i]) continue;
                if (MarvinToolPanel.this.arrTools[MarvinToolPanel.this.currentTool].getSettingsWindow() != null) {
                    MarvinToolPanel.this.remove(MarvinToolPanel.this.arrTools[MarvinToolPanel.this.currentTool].getSettingsWindow().getContentPane());
                }
                MarvinToolPanel.this.currentTool = i;
                Image img = MarvinToolPanel.this.arrTools[MarvinToolPanel.this.currentTool].getCursorImage();
                if (img != null) {
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    Cursor cursor = tk.createCustomCursor(img, MarvinToolPanel.this.arrTools[MarvinToolPanel.this.currentTool].getCursorHotSpot(), "curstomCursor");
                    MarvinToolPanel.this.currentImagePanel.setCursor(cursor);
                } else {
                    MarvinToolPanel.this.currentImagePanel.setCursor(Cursor.getDefaultCursor());
                }
                if (MarvinToolPanel.this.arrTools[MarvinToolPanel.this.currentTool].getSettingsWindow() != null) {
                    MarvinToolPanel.this.add(MarvinToolPanel.this.arrTools[MarvinToolPanel.this.currentTool].getSettingsWindow().getContentPane());
                }
                MarvinToolPanel.this.validate();
                MarvinToolPanel.this.repaint();
            }
        }
    }
}

