/*
 * Decompiled with CFR 0.152.
 */
package marvin.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import marvin.gui.MarvinAttributesPanel;
import marvin.gui.MarvinImagePanel;
import marvin.gui.MarvinPluginWindow;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinImagePlugin;

public class MarvinFilterWindow
extends MarvinPluginWindow {
    protected JPanel panelFixedComponents;
    protected JPanel panelImage;
    protected JButton buttonPreview;
    protected JButton buttonApply;
    protected JButton buttonReset;
    protected JLabel labelImage;
    MarvinImagePanel imagePanel;
    MarvinAttributesPanel attributesPanel;
    MarvinImage imageThumbnail;
    MarvinImage imageResetBuffer;
    MarvinImage imageOut;
    MarvinImagePlugin plugin;
    protected ActionHandler actionHandler;

    public MarvinFilterWindow(String name, int width, int height, MarvinImagePanel ip, MarvinImagePlugin filter) {
        this(name, width, height, 250, 250, ip, filter);
    }

    public MarvinFilterWindow(String name, int width, int height, int thumbWidth, int thumbHeight, MarvinImagePanel ip, MarvinImagePlugin plg) {
        super(name, width, height, plg.getAttributesPanel());
        this.attributesPanel = plg.getAttributesPanel();
        if (this.attributesPanel != null) {
            int newWidth = width;
            if (this.attributesPanel.getPreferredSize().width > width) {
                newWidth = this.attributesPanel.getPreferredSize().width + 20;
            }
            this.setSize(newWidth, height + this.attributesPanel.getPreferredSize().height);
        }
        this.imagePanel = ip;
        this.plugin = plg;
        this.actionHandler = new ActionHandler();
        this.buttonPreview = new JButton("Preview");
        this.buttonReset = new JButton("Reset");
        this.buttonApply = new JButton("Apply");
        this.buttonPreview.setMnemonic('P');
        this.buttonReset.setMnemonic('R');
        this.buttonApply.setMnemonic('A');
        this.buttonPreview.addActionListener(this.actionHandler);
        this.buttonReset.addActionListener(this.actionHandler);
        this.buttonApply.addActionListener(this.actionHandler);
        this.panelFixedComponents = new JPanel();
        this.panelFixedComponents.setLayout(new FlowLayout());
        this.panelFixedComponents.add(this.buttonPreview);
        this.panelFixedComponents.add(this.buttonReset);
        this.panelFixedComponents.add(this.buttonApply);
        this.panelImage = new JPanel();
        this.panelImage.setLayout(new FlowLayout());
        if (thumbWidth > 0 && thumbHeight > 0) {
            this.imageThumbnail = new MarvinImage(this.imagePanel.getImage().getBufferedImage(thumbWidth, thumbHeight, 0));
            this.imageResetBuffer = this.imageThumbnail.clone();
            this.labelImage = new JLabel(new ImageIcon(this.imageThumbnail.getBufferedImage()));
            this.panelImage.add(this.labelImage);
        }
        this.imageOut = new MarvinImage(this.imagePanel.getImage().getWidth(), this.imagePanel.getImage().getHeight(), this.imagePanel.getImage().getColorModel());
        this.container.add((Component)this.panelImage, "North");
        this.container.add((Component)this.panelCenter, "Center");
        this.container.add((Component)this.panelFixedComponents, "South");
    }

    public void disablePreview() {
        this.panelFixedComponents.remove(this.buttonPreview);
        this.panelFixedComponents.remove(this.buttonReset);
        this.panelImage.remove(this.labelImage);
    }

    public JButton getApplyButton() {
        return this.buttonApply;
    }

    public void preview() {
        try {
            this.imageThumbnail = this.imageResetBuffer.clone();
            MarvinImage imgOut = new MarvinImage(this.imageThumbnail.getWidth(), this.imageThumbnail.getHeight());
            this.plugin.process(this.imageThumbnail, imgOut, null, MarvinImageMask.NULL_MASK, true);
            imgOut.update();
            this.imageThumbnail = imgOut.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.labelImage.setIcon(new ImageIcon(this.imageThumbnail.getBufferedImage()));
    }

    public void reset() {
        this.imageThumbnail = new MarvinImage(this.imageResetBuffer.getNewImageInstance());
        this.labelImage.setIcon(new ImageIcon(this.imageThumbnail.getBufferedImage()));
    }

    public void apply() {
        this.dispose();
        this.plugin.process(this.imagePanel.getImage(), this.imageOut, null, MarvinImageMask.NULL_MASK, false);
        if (this.imagePanel.isHistoryEnabled()) {
            this.imagePanel.getHistory().addEntry(this.plugin.getClass().getSimpleName(), this.imageOut, this.plugin.getAttributes());
        }
        this.imageOut.update();
        this.imagePanel.setImage(this.imageOut);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MarvinFilterWindow.this.buttonApply) {
                if (MarvinFilterWindow.this.attributesPanel != null) {
                    MarvinFilterWindow.this.attributesPanel.applyValues();
                }
                MarvinFilterWindow.this.apply();
            } else if (e.getSource() == MarvinFilterWindow.this.buttonReset) {
                MarvinFilterWindow.this.reset();
            } else if (e.getSource() == MarvinFilterWindow.this.buttonPreview) {
                if (MarvinFilterWindow.this.attributesPanel != null) {
                    MarvinFilterWindow.this.attributesPanel.applyValues();
                }
                MarvinFilterWindow.this.preview();
            }
        }
    }
}

