/*
 * Decompiled with CFR 0.152.
 */
package marvin.gui;

import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import marvin.gui.MarvinImagePanel;
import marvin.gui.MarvinToolPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinToolPlugin;

public class MarvinEditableImagePanel
extends MarvinImagePanel
implements Runnable {
    private MarvinToolPanel toolPanel;
    private MarvinImageMask imageMask = new MarvinImageMask();
    private MarvinToolPlugin tempTool;
    private Thread thread;
    private MouseEvent mouseEvent;
    private int mousePx;
    private int mousePy;
    private boolean pressed;
    private MouseHandler mouseHandler = new MouseHandler();
    private Point locationOnScreen;

    public MarvinEditableImagePanel() {
        this.addMouseListener(this.mouseHandler);
        this.pressed = false;
    }

    @Override
    public void setImage(MarvinImage img) {
        super.setImage(img);
        this.imageMask = new MarvinImageMask(img.getWidth(), img.getHeight());
    }

    public void setToolPanel(MarvinToolPanel tp) {
        if (this.toolPanel != tp) {
            this.toolPanel = tp;
            this.toolPanel.setImagePanel(this);
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
    }

    public MarvinToolPanel getToolPanel() {
        return this.toolPanel;
    }

    @Override
    public void run() {
        while (true) {
            if (this.tempTool == null) {
                continue;
            }
            this.locationOnScreen = this.getLocationOnScreen();
            this.mousePx = (int)MouseInfo.getPointerInfo().getLocation().getX();
            this.mousePy = (int)MouseInfo.getPointerInfo().getLocation().getY();
            this.mousePx -= this.locationOnScreen.x;
            this.mousePy -= this.locationOnScreen.y;
            if (this.pressed) {
                this.tempTool.mousePressed(this.image, this.imageMask, this.mousePx, this.mousePy);
                this.image.update();
            }
            this.update();
        }
    }

    @Override
    public void paintComponent(Graphics a_graphics) {
        super.paintComponent(a_graphics);
        if (this.tempTool != null) {
            this.tempTool.update(a_graphics);
        }
    }

    private void deleteSelected() {
        boolean[][] mask = this.imageMask.getMask();
        for (int y = 0; y < this.image.getHeight(); ++y) {
            for (int x = 0; x < this.image.getWidth(); ++x) {
                if (!mask[x][y]) continue;
                this.image.setIntColor(x, y, -1);
            }
        }
        this.image.update();
        this.update();
    }

    private class MouseHandler
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            MarvinEditableImagePanel.this.toolPanel.getCurrentTool().mouseClicked(MarvinEditableImagePanel.this.image, MarvinEditableImagePanel.this.imageMask, event.getX(), event.getY());
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            MarvinEditableImagePanel.this.mouseEvent = event;
            if (MarvinEditableImagePanel.this.toolPanel != null) {
                MarvinEditableImagePanel.this.tempTool = MarvinEditableImagePanel.this.toolPanel.getCurrentTool();
            }
            MarvinEditableImagePanel.this.pressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            MarvinEditableImagePanel.this.toolPanel.getCurrentTool().mouseReleased(MarvinEditableImagePanel.this.image, MarvinEditableImagePanel.this.imageMask, MarvinEditableImagePanel.this.mousePx, MarvinEditableImagePanel.this.mousePy);
            MarvinEditableImagePanel.this.pressed = false;
        }
    }
}

