/*
 * Decompiled with CFR 0.152.
 */
package marvin.gui;

import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marvin.gui.MarvinPluginWindowComponent;
import marvin.gui.component.MarvinMatrixPanel;
import marvin.util.MarvinAttributes;

public class MarvinAttributesPanel
extends Box {
    private static FlowLayout flowLayout = new FlowLayout();
    protected Hashtable<String, MarvinPluginWindowComponent> hashComponents = new Hashtable(10, 5.0f);
    protected Enumeration<MarvinPluginWindowComponent> enumComponents;
    private JPanel panelCurrent;

    public MarvinAttributesPanel() {
        super(3);
        this.newComponentRow();
    }

    public void newComponentRow() {
        this.newComponentRow(flowLayout);
    }

    public void newComponentRow(LayoutManager layout) {
        this.panelCurrent = new JPanel();
        this.panelCurrent.setLayout(layout);
        this.add(this.panelCurrent);
    }

    public JPanel getCurrentComponentRow() {
        return this.panelCurrent;
    }

    public JPanel getCurrentPanel() {
        return this.panelCurrent;
    }

    public void plugComponent(JComponent comp) {
        this.panelCurrent.add(comp);
    }

    public void plugComponent(String id, JComponent comp, String attrID, MarvinAttributes attr, MarvinPluginWindowComponent.ComponentType type) {
        this.panelCurrent.add(comp);
        this.hashComponents.put(id, new MarvinPluginWindowComponent(id, attrID, attr, comp, type));
    }

    public MarvinPluginWindowComponent getComponent(String compID) {
        return this.hashComponents.get(compID);
    }

    public void addLabel(String id, String text) {
        JLabel comp = new JLabel(text);
        this.plugComponent(id, comp, null, null, MarvinPluginWindowComponent.ComponentType.COMPONENT_LABEL);
    }

    public void addImage(String id, BufferedImage img) {
        JLabel comp = new JLabel(new ImageIcon(img));
        this.plugComponent(id, comp, null, null, MarvinPluginWindowComponent.ComponentType.COMPONENT_IMAGE);
    }

    public void addTextField(String id, String attrID, MarvinAttributes attr) {
        JTextField comp = new JTextField(5);
        comp.setText(attr.get(attrID).toString());
        this.plugComponent(id, comp, attrID, attr, MarvinPluginWindowComponent.ComponentType.COMPONENT_TEXTFIELD);
    }

    public void addTextArea(String id, String attrID, int lines, int columns, MarvinAttributes attr) {
        JTextArea comp = new JTextArea(lines, columns);
        JScrollPane scrollPanel = new JScrollPane(comp);
        comp.setText(attr.get(attrID).toString());
        this.panelCurrent.add(scrollPanel);
        this.hashComponents.put(id, new MarvinPluginWindowComponent(id, attrID, attr, comp, MarvinPluginWindowComponent.ComponentType.COMPONENT_TEXTAREA));
    }

    public void addComboBox(String id, String attrID, Object[] items, MarvinAttributes attr) {
        JComboBox<Object> comp = new JComboBox<Object>(items);
        this.plugComponent(id, comp, attrID, attr, MarvinPluginWindowComponent.ComponentType.COMPONENT_COMBOBOX);
    }

    protected void addSlider(String id, String attrID, int orientation, int a_min, int a_max, int a_value, MarvinAttributes attr) {
        final JSlider slider = new JSlider(orientation, a_min, a_max, a_value);
        this.plugComponent(id, slider, attrID, attr, MarvinPluginWindowComponent.ComponentType.COMPONENT_SLIDER);
        final JTextField field = new JTextField(("" + a_max).length());
        field.setText("" + a_value);
        this.plugComponent(field);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                field.setText("" + slider.getValue());
            }
        });
        field.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ("ENTER".equals(KeyEvent.getKeyText(e.getKeyChar()).toUpperCase())) {
                    slider.setValue(Integer.parseInt(field.getText()));
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void addHorizontalSlider(String id, String attrID, int min, int max, int value, MarvinAttributes attr) {
        this.addSlider(id, attrID, 0, min, max, value, attr);
    }

    public void addVerticalSlider(String id, String attrID, int min, int max, int value, MarvinAttributes attr) {
        this.addSlider(id, attrID, 1, min, max, value, attr);
    }

    public void addCheckBox(String id, String cbText, String attrID, MarvinAttributes attr) {
        JCheckBox comp = new JCheckBox(cbText);
        this.plugComponent(id, comp, attrID, attr, MarvinPluginWindowComponent.ComponentType.COMPONENT_CHECKBOX);
    }

    public void addButtonGroup(String id, String attrID, MarvinAttributes attr) {
    }

    public void addMatrixPanel(String id, String attrID, MarvinAttributes attr, int rows, int columns) {
        MarvinMatrixPanel comp = new MarvinMatrixPanel(rows, columns);
        this.plugComponent(id, comp, attrID, attr, MarvinPluginWindowComponent.ComponentType.COMPONENT_MATRIX_PANEL);
    }

    public void applyValues() {
        this.enumComponents = this.hashComponents.elements();
        while (this.enumComponents.hasMoreElements()) {
            MarvinPluginWindowComponent filterComp = this.enumComponents.nextElement();
            if (filterComp.getAttributes() == null) continue;
            filterComp.getAttributes().set(filterComp.getAttributeID(), this.getValue(filterComp));
        }
    }

    public Object stringToType(String value, Object type) {
        Class<?> l_class = type.getClass();
        if (l_class == Double.class) {
            return Double.parseDouble(value);
        }
        if (l_class == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (l_class == Integer.class) {
            return Integer.parseInt(value);
        }
        if (l_class == String.class) {
            return value.toString();
        }
        if (l_class == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public Object getValue(MarvinPluginWindowComponent plgComp) {
        String l_id = plgComp.getAttributeID();
        MarvinAttributes attr = plgComp.getAttributes();
        JComponent comp = plgComp.getComponent();
        switch (plgComp.getType()) {
            case COMPONENT_TEXTFIELD: {
                return this.stringToType(((JTextField)comp).getText(), attr.get(l_id));
            }
            case COMPONENT_COMBOBOX: {
                return ((JComboBox)comp).getSelectedItem();
            }
            case COMPONENT_SLIDER: {
                return ((JSlider)comp).getValue();
            }
            case COMPONENT_TEXTAREA: {
                return ((JTextArea)comp).getText();
            }
            case COMPONENT_CHECKBOX: {
                return ((JCheckBox)comp).isSelected();
            }
            case COMPONENT_MATRIX_PANEL: {
                return ((MarvinMatrixPanel)comp).getValue();
            }
        }
        return null;
    }
}

