/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt.io;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Method;

public class NbtBinarySerializer {
    public static final NbtBinarySerializer DEFAULT = new NbtBinarySerializer();
    private static final Class<?> NBT_BASE_CLASS = MinecraftReflection.getNBTBaseClass();
    private static MethodAccessor methodWrite;
    private static LoadMethod loadMethod;

    private static MethodAccessor getNbtLoadMethod(Class<?> ... parameters) {
        Method method = NbtBinarySerializer.getUtilityClass().getMethodByReturnTypeAndParameters("load", NBT_BASE_CLASS, parameters);
        return Accessors.getMethodAccessor(method);
    }

    private static FuzzyReflection getUtilityClass() {
        return FuzzyReflection.fromClass(MinecraftReflection.getNbtCompressedStreamToolsClass(), true);
    }

    public <T> void serialize(NbtBase<T> value, DataOutput destination) {
        if (methodWrite == null) {
            Class<?> base = MinecraftReflection.getNBTBaseClass();
            Method writeNBT = NbtBinarySerializer.getUtilityClass().getMethodByParameters("writeNBT", base, DataOutput.class);
            methodWrite = Accessors.getMethodAccessor(writeNBT);
        }
        methodWrite.invoke(null, NbtFactory.fromBase(value).getHandle(), destination);
    }

    public <TType> NbtWrapper<TType> deserialize(DataInput source) {
        if (loadMethod == null) {
            loadMethod = new LoadMethodSkinUpdate();
        }
        try {
            return NbtFactory.fromNMS(loadMethod.loadNbt(source), null);
        }
        catch (Exception e) {
            throw new FieldAccessException("Unable to read NBT from " + source, e);
        }
    }

    public NbtCompound deserializeCompound(DataInput source) {
        return (NbtCompound)((Object)this.deserialize(source));
    }

    public <T> NbtList<T> deserializeList(DataInput source) {
        return (NbtList)((Object)this.deserialize(source));
    }

    static /* synthetic */ MethodAccessor access$100(Class[] x0) {
        return NbtBinarySerializer.getNbtLoadMethod(x0);
    }

    private static interface LoadMethod {
        public Object loadNbt(DataInput var1);
    }

    private static class LoadMethodSkinUpdate
    implements LoadMethod {
        private final Class<?> readLimitClass = MinecraftReflection.getNBTReadLimiterClass();
        private final Object readLimiter = FuzzyReflection.fromClass(this.readLimitClass).getSingleton();
        private final MethodAccessor accessor = NbtBinarySerializer.access$100(new Class[]{DataInput.class, Integer.TYPE, this.readLimitClass});

        private LoadMethodSkinUpdate() {
        }

        @Override
        public Object loadNbt(DataInput input) {
            return this.accessor.invoke(null, input, 0, this.readLimiter);
        }
    }
}

