/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.scheduler;

import com.comphenix.protocol.scheduler.DefaultTask;
import com.comphenix.protocol.scheduler.ProtocolScheduler;
import com.comphenix.protocol.scheduler.Task;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class DefaultScheduler
implements ProtocolScheduler {
    private final Plugin plugin;
    private final BukkitScheduler scheduler;

    public DefaultScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.scheduler = plugin.getServer().getScheduler();
    }

    @Override
    public Task scheduleSyncRepeatingTask(Runnable task, long delay, long period) {
        int taskId = this.scheduler.scheduleSyncRepeatingTask(this.plugin, task, delay, period);
        return taskId >= 0 ? new DefaultTask(this.scheduler, taskId) : null;
    }

    @Override
    public Task runTask(Runnable task) {
        int taskId = this.scheduler.runTask(this.plugin, task).getTaskId();
        return taskId >= 0 ? new DefaultTask(this.scheduler, taskId) : null;
    }

    @Override
    public Task scheduleSyncDelayedTask(Runnable task, long delay) {
        int taskId = this.scheduler.scheduleSyncDelayedTask(this.plugin, task, delay);
        return taskId >= 0 ? new DefaultTask(this.scheduler, taskId) : null;
    }
}

