/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import com.google.common.base.Objects;
import com.google.common.collect.Range;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractIntervalTree<TKey extends Comparable<TKey>, TValue> {
    protected NavigableMap<TKey, EndPoint> bounds = new TreeMap<TKey, EndPoint>();

    public Set<Entry> remove(TKey lowerBound, TKey upperBound) {
        return this.remove(lowerBound, upperBound, false);
    }

    public Set<Entry> remove(TKey lowerBound, TKey upperBound, boolean preserveDifference) {
        this.checkBounds(lowerBound, upperBound);
        NavigableMap<TKey, EndPoint> range = this.bounds.subMap(lowerBound, true, upperBound, true);
        EndPoint first = this.getNextEndPoint(lowerBound, true);
        EndPoint last = this.getPreviousEndPoint(upperBound, true);
        EndPoint previous = null;
        EndPoint next = null;
        HashSet<Entry> resized = new HashSet<Entry>();
        HashSet<Entry> removed = new HashSet<Entry>();
        if (first != null && first.state == State.CLOSE && (previous = this.getPreviousEndPoint(first.key, false)) != null) {
            removed.add(this.getEntry(previous, first));
        }
        if (last != null && last.state == State.OPEN && (next = this.getNextEndPoint(last.key, false)) != null) {
            removed.add(this.getEntry(last, next));
        }
        this.removeEntrySafely(previous, first);
        this.removeEntrySafely(last, next);
        if (preserveDifference) {
            if (previous != null) {
                resized.add(this.putUnsafe(previous.key, this.decrementKey(lowerBound), previous.value));
            }
            if (next != null) {
                resized.add(this.putUnsafe(this.incrementKey(upperBound), next.key, next.value));
            }
        }
        this.getEntries(removed, range);
        this.invokeEntryRemoved(removed);
        if (preserveDifference) {
            this.invokeEntryAdded(resized);
        }
        range.clear();
        return removed;
    }

    protected Entry getEntry(EndPoint left, EndPoint right) {
        if (left == null) {
            throw new IllegalArgumentException("left endpoint cannot be NULL.");
        }
        if (right == null) {
            throw new IllegalArgumentException("right endpoint cannot be NULL.");
        }
        if (right.key.compareTo(left.key) < 0) {
            return this.getEntry(right, left);
        }
        return new Entry(left, right);
    }

    private void removeEntrySafely(EndPoint left, EndPoint right) {
        if (left != null && right != null) {
            this.bounds.remove(left.key);
            this.bounds.remove(right.key);
        }
    }

    protected EndPoint addEndPoint(TKey key, TValue value, State state) {
        EndPoint endPoint = (EndPoint)this.bounds.get(key);
        if (endPoint != null) {
            endPoint.state = State.BOTH;
        } else {
            endPoint = new EndPoint(this, state, key, value);
            this.bounds.put(key, endPoint);
        }
        return endPoint;
    }

    public void put(TKey lowerBound, TKey upperBound, TValue value) {
        this.remove(lowerBound, upperBound, true);
        this.invokeEntryAdded(this.putUnsafe(lowerBound, upperBound, value));
    }

    private Entry putUnsafe(TKey lowerBound, TKey upperBound, TValue value) {
        if (value != null) {
            EndPoint left = this.addEndPoint(lowerBound, value, State.OPEN);
            EndPoint right = this.addEndPoint(upperBound, value, State.CLOSE);
            return new Entry(left, right);
        }
        return null;
    }

    private void checkBounds(TKey lowerBound, TKey upperBound) {
        if (lowerBound == null) {
            throw new IllegalAccessError("lowerbound cannot be NULL.");
        }
        if (upperBound == null) {
            throw new IllegalAccessError("upperBound cannot be NULL.");
        }
        if (upperBound.compareTo(lowerBound) < 0) {
            throw new IllegalArgumentException("upperBound cannot be less than lowerBound.");
        }
    }

    public boolean containsKey(TKey key) {
        return this.getEndPoint(key) != null;
    }

    public Set<Entry> entrySet() {
        HashSet<Entry> result = new HashSet<Entry>();
        this.getEntries(result, this.bounds);
        return result;
    }

    public void clear() {
        if (!this.bounds.isEmpty()) {
            this.remove((Comparable)this.bounds.firstKey(), (Comparable)this.bounds.lastKey());
        }
    }

    private void getEntries(Set<Entry> destination, NavigableMap<TKey, EndPoint> map) {
        Map.Entry last = null;
        block5: for (Map.Entry entry : map.entrySet()) {
            switch (((EndPoint)entry.getValue()).state) {
                case BOTH: {
                    EndPoint point = (EndPoint)entry.getValue();
                    destination.add(new Entry(point, point));
                    continue block5;
                }
                case CLOSE: {
                    if (last == null) continue block5;
                    destination.add(new Entry((EndPoint)last.getValue(), (EndPoint)entry.getValue()));
                    continue block5;
                }
                case OPEN: {
                    last = entry;
                    continue block5;
                }
            }
            throw new IllegalStateException("Illegal open/close state detected.");
        }
    }

    public void putAll(AbstractIntervalTree<TKey, TValue> other) {
        for (Entry entry : other.entrySet()) {
            this.put(((Entry)entry).left.key, ((Entry)entry).right.key, entry.getValue());
        }
    }

    public TValue get(TKey key) {
        EndPoint point = this.getEndPoint(key);
        if (point != null) {
            return point.value;
        }
        return null;
    }

    protected EndPoint getEndPoint(TKey key) {
        EndPoint ends = (EndPoint)this.bounds.get(key);
        if (ends != null) {
            if (ends.state == State.CLOSE) {
                Map.Entry<TKey, EndPoint> left = this.bounds.floorEntry(this.decrementKey(key));
                return left != null ? left.getValue() : null;
            }
            return ends;
        }
        Map.Entry<TKey, EndPoint> left = this.bounds.floorEntry(key);
        if (left != null && left.getValue().state == State.OPEN) {
            return left.getValue();
        }
        return null;
    }

    protected EndPoint getPreviousEndPoint(TKey point, boolean inclusive) {
        Map.Entry<TKey, EndPoint> previous;
        if (point != null && (previous = this.bounds.floorEntry(inclusive ? point : this.decrementKey(point))) != null) {
            return previous.getValue();
        }
        return null;
    }

    protected EndPoint getNextEndPoint(TKey point, boolean inclusive) {
        Map.Entry<TKey, EndPoint> next;
        if (point != null && (next = this.bounds.ceilingEntry(inclusive ? point : this.incrementKey(point))) != null) {
            return next.getValue();
        }
        return null;
    }

    private void invokeEntryAdded(Entry added) {
        if (added != null) {
            this.onEntryAdded(added);
        }
    }

    private void invokeEntryAdded(Set<Entry> added) {
        for (Entry entry : added) {
            this.onEntryAdded(entry);
        }
    }

    private void invokeEntryRemoved(Set<Entry> removed) {
        for (Entry entry : removed) {
            this.onEntryRemoved(entry);
        }
    }

    protected void onEntryAdded(Entry added) {
    }

    protected void onEntryRemoved(Entry removed) {
    }

    protected abstract TKey decrementKey(TKey var1);

    protected abstract TKey incrementKey(TKey var1);

    protected static class EndPoint {
        public State state;
        public TValue value;
        public TKey key;
        final /* synthetic */ AbstractIntervalTree this$0;

        public EndPoint(State state, TKey key, TValue value) {
            this.this$0 = this$0;
            this.state = state;
            this.key = key;
            this.value = value;
        }
    }

    protected static enum State {
        OPEN,
        CLOSE,
        BOTH;

    }

    public class Entry
    implements Map.Entry<Range<TKey>, TValue> {
        private final EndPoint left;
        private final EndPoint right;

        Entry(EndPoint left, EndPoint right) {
            if (left == null) {
                throw new IllegalAccessError("left cannot be NUll");
            }
            if (right == null) {
                throw new IllegalAccessError("right cannot be NUll");
            }
            if (left.key.compareTo(right.key) > 0) {
                throw new IllegalArgumentException("Left key (" + left.key + ") cannot be greater than the right key (" + right.key + ")");
            }
            this.left = left;
            this.right = right;
        }

        @Override
        public Range<TKey> getKey() {
            return Range.closed(this.left.key, this.right.key);
        }

        @Override
        public TValue getValue() {
            return this.left.value;
        }

        @Override
        public TValue setValue(TValue value) {
            Object old = this.left.value;
            this.left.value = value;
            this.right.value = value;
            return old;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Entry) {
                return Objects.equal(this.left.key, ((Entry)obj).left.key) && Objects.equal(this.right.key, ((Entry)obj).right.key) && Objects.equal(this.left.value, ((Entry)obj).left.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.left.key, this.right.key, this.left.value});
        }

        public String toString() {
            return String.format("Value %s at [%s, %s]", this.left.value, this.left.key, this.right.key);
        }
    }
}

