/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.ping;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftProtocolVersion;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.ping.ServerPingImpl;
import com.google.common.collect.ImmutableList;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public final class LegacyServerPing
extends AbstractWrapper
implements ServerPingImpl {
    private static final Class<?> GAME_PROFILE = MinecraftReflection.getGameProfileClass();
    private static final EquivalentConverter<Iterable<? extends WrappedGameProfile>> PROFILE_CONVERT = BukkitConverters.getArrayConverter(GAME_PROFILE, BukkitConverters.getWrappedGameProfileConverter());
    private static final FieldAccessor ENTITY_HUMAN_PROFILE = Accessors.getFieldAccessor(MinecraftReflection.getEntityPlayerClass().getSuperclass(), GAME_PROFILE, true);
    private static final Class<?> GAME_PROFILE_ARRAY = MinecraftReflection.getArrayClass(GAME_PROFILE);
    private static final Class<?> SERVER_PING = MinecraftReflection.getServerPingClass();
    private static final ConstructorAccessor SERVER_PING_CONSTRUCTOR = Accessors.getConstructorAccessor(SERVER_PING, new Class[0]);
    private static final FieldAccessor DESCRIPTION = Accessors.getFieldAccessor(SERVER_PING, MinecraftReflection.getIChatBaseComponentClass(), true);
    private static final FieldAccessor PLAYERS = Accessors.getFieldAccessor(SERVER_PING, MinecraftReflection.getServerPingPlayerSampleClass(), true);
    private static final FieldAccessor VERSION = Accessors.getFieldAccessor(SERVER_PING, MinecraftReflection.getServerPingServerDataClass(), true);
    private static final FieldAccessor FAVICON = Accessors.getFieldAccessor(SERVER_PING, String.class, true);
    private static final FieldAccessor[] BOOLEAN_ACCESSORS = Accessors.getFieldAccessorArray(SERVER_PING, Boolean.TYPE, true);
    private static final Class<?> PLAYERS_CLASS = MinecraftReflection.getServerPingPlayerSampleClass();
    private static final ConstructorAccessor PLAYERS_CONSTRUCTOR = Accessors.getConstructorAccessor(PLAYERS_CLASS, Integer.TYPE, Integer.TYPE);
    private static final FieldAccessor[] PLAYERS_INTS = Accessors.getFieldAccessorArray(PLAYERS_CLASS, Integer.TYPE, true);
    private static final FieldAccessor PLAYERS_PROFILES = Accessors.getFieldAccessor(PLAYERS_CLASS, GAME_PROFILE_ARRAY, true);
    private static final FieldAccessor PLAYERS_MAXIMUM = PLAYERS_INTS[0];
    private static final FieldAccessor PLAYERS_ONLINE = PLAYERS_INTS[1];
    private static final Class<?> GSON_CLASS = MinecraftReflection.getMinecraftGsonClass();
    private static final MethodAccessor GSON_TO_JSON = Accessors.getMethodAccessor(GSON_CLASS, "toJson", Object.class);
    private static final MethodAccessor GSON_FROM_JSON = Accessors.getMethodAccessor(GSON_CLASS, "fromJson", String.class, Class.class);
    private static final FieldAccessor PING_GSON = Accessors.getMemorizing(Accessors.getFieldAccessor(PacketType.Status.Server.SERVER_INFO.getPacketClass(), GSON_CLASS, true));
    private static final Class<?> VERSION_CLASS = MinecraftReflection.getServerPingServerDataClass();
    private static final ConstructorAccessor VERSION_CONSTRUCTOR = Accessors.getConstructorAccessor(VERSION_CLASS, String.class, Integer.TYPE);
    private static final FieldAccessor VERSION_NAME = Accessors.getFieldAccessor(VERSION_CLASS, String.class, true);
    private static final FieldAccessor VERSION_PROTOCOL = Accessors.getFieldAccessor(VERSION_CLASS, Integer.TYPE, true);
    private Object players;
    private Object version;

    public LegacyServerPing() {
        super(MinecraftReflection.getServerPingClass());
        this.setHandle(SERVER_PING_CONSTRUCTOR.invoke(new Object[0]));
        this.resetPlayers();
        this.resetVersion();
    }

    public LegacyServerPing(Object handle) {
        super(MinecraftReflection.getServerPingClass());
        this.setHandle(handle);
        this.players = PLAYERS.get(handle);
        this.version = VERSION.get(handle);
    }

    @Override
    public void resetPlayers() {
        this.players = PLAYERS_CONSTRUCTOR.invoke(0, 0);
        PLAYERS.set(this.handle, this.players);
    }

    @Override
    public void resetVersion() {
        MinecraftVersion minecraftVersion = MinecraftVersion.getCurrentVersion();
        this.version = VERSION_CONSTRUCTOR.invoke(minecraftVersion.toString(), MinecraftProtocolVersion.getCurrentVersion());
        VERSION.set(this.handle, this.version);
    }

    public static LegacyServerPing fromHandle(Object handle) {
        return new LegacyServerPing(handle);
    }

    public static LegacyServerPing fromJson(String json) {
        return LegacyServerPing.fromHandle(GSON_FROM_JSON.invoke(PING_GSON.get(null), json, SERVER_PING));
    }

    @Override
    public WrappedChatComponent getMotD() {
        return WrappedChatComponent.fromHandle(DESCRIPTION.get(this.handle));
    }

    @Override
    public void setMotD(WrappedChatComponent description) {
        DESCRIPTION.set(this.handle, description != null ? description.getHandle() : null);
    }

    @Override
    public String getFavicon() {
        return (String)FAVICON.get(this.handle);
    }

    @Override
    public void setFavicon(String image) {
        FAVICON.set(this.handle, image);
    }

    @Override
    @Deprecated
    public boolean isChatPreviewEnabled() {
        return (Boolean)BOOLEAN_ACCESSORS[0].get(this.handle);
    }

    @Override
    @Deprecated
    public void setChatPreviewEnabled(boolean chatPreviewEnabled) {
        BOOLEAN_ACCESSORS[0].set(this.handle, chatPreviewEnabled);
    }

    @Override
    public boolean isEnforceSecureChat() {
        int index = MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove() ? 0 : 1;
        return (Boolean)BOOLEAN_ACCESSORS[index].get(this.handle);
    }

    @Override
    public void setEnforceSecureChat(boolean enforceSecureChat) {
        int index = MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove() ? 0 : 1;
        BOOLEAN_ACCESSORS[index].set(this.handle, enforceSecureChat);
    }

    @Override
    public int getPlayersOnline() {
        if (this.players == null) {
            throw new IllegalStateException("The player count has been hidden.");
        }
        return (Integer)PLAYERS_ONLINE.get(this.players);
    }

    @Override
    public void setPlayersOnline(int online) {
        if (this.players == null) {
            this.resetPlayers();
        }
        PLAYERS_ONLINE.set(this.players, online);
    }

    @Override
    public int getPlayersMaximum() {
        if (this.players == null) {
            throw new IllegalStateException("The player maximum has been hidden.");
        }
        return (Integer)PLAYERS_MAXIMUM.get(this.players);
    }

    @Override
    public void setPlayersMaximum(int maximum) {
        if (this.players == null) {
            this.resetPlayers();
        }
        PLAYERS_MAXIMUM.set(this.players, maximum);
    }

    @Override
    public void setPlayersVisible(boolean visible) {
        if (this.arePlayersVisible() != visible) {
            if (visible) {
                Server server = Bukkit.getServer();
                this.setPlayersMaximum(server.getMaxPlayers());
                this.setPlayersOnline(Bukkit.getOnlinePlayers().size());
            } else {
                this.players = null;
                PLAYERS.set(this.handle, null);
            }
        }
    }

    @Override
    public String getJson() {
        return (String)GSON_TO_JSON.invoke(PING_GSON.get(null), this.getHandle());
    }

    @Override
    public boolean arePlayersVisible() {
        return this.players != null;
    }

    @Override
    public ImmutableList<WrappedGameProfile> getPlayers() {
        if (this.players == null) {
            return ImmutableList.of();
        }
        Object playerProfiles = PLAYERS_PROFILES.get(this.players);
        if (playerProfiles == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(PROFILE_CONVERT.getSpecific(playerProfiles));
    }

    @Override
    public void setPlayers(Iterable<? extends WrappedGameProfile> playerSample) {
        if (this.players == null) {
            this.resetPlayers();
        }
        PLAYERS_PROFILES.set(this.players, PROFILE_CONVERT.getGeneric(playerSample));
    }

    @Override
    public String getVersionName() {
        return (String)VERSION_NAME.get(this.version);
    }

    @Override
    public void setVersionName(String name) {
        VERSION_NAME.set(this.version, name);
    }

    @Override
    public int getVersionProtocol() {
        return (Integer)VERSION_PROTOCOL.get(this.version);
    }

    @Override
    public void setVersionProtocol(int protocol) {
        VERSION_PROTOCOL.set(this.version, protocol);
    }

    public LegacyServerPing deepClone() {
        LegacyServerPing copy = new LegacyServerPing();
        WrappedChatComponent motd = this.getMotD();
        copy.setPlayers((Iterable<? extends WrappedGameProfile>)this.getPlayers());
        copy.setFavicon(this.getFavicon());
        copy.setMotD(motd != null ? motd : null);
        copy.setVersionName(this.getVersionName());
        copy.setVersionProtocol(this.getVersionProtocol());
        if (this.arePlayersVisible()) {
            copy.setPlayersMaximum(this.getPlayersMaximum());
            copy.setPlayersOnline(this.getPlayersOnline());
        } else {
            copy.setPlayersVisible(false);
        }
        return copy;
    }

    public String toJson() {
        return (String)GSON_TO_JSON.invoke(PING_GSON.get(null), this.handle);
    }

    @Override
    public String toString() {
        return "WrappedServerPing< " + this.toJson() + ">";
    }
}

