/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.MinecraftReflection;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class MinecraftMethods {
    private static volatile MethodAccessor sendPacketMethod;
    private static volatile MethodAccessor disconnectMethod;
    private static volatile MethodAccessor networkManagerHandle;
    private static volatile MethodAccessor networkManagerPacketRead;
    private static volatile MethodAccessor packetReadByteBuf;
    private static volatile MethodAccessor packetWriteByteBuf;
    private static volatile ConstructorAccessor decoratedDataSerializerAccessor;

    private MinecraftMethods() {
    }

    public static MethodAccessor getSendPacketMethod() {
        if (sendPacketMethod == null) {
            FuzzyReflection serverHandlerClass = FuzzyReflection.fromClass(MinecraftReflection.getPlayerConnectionClass());
            try {
                sendPacketMethod = Accessors.getMethodAccessor(serverHandlerClass.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).returnTypeVoid().parameterExactType(MinecraftReflection.getPacketClass(), 0).build()));
            }
            catch (IllegalArgumentException e) {
                sendPacketMethod = Accessors.getMethodAccessor(serverHandlerClass.getMethod(FuzzyMethodContract.newBuilder().nameRegex("sendPacket.*").returnTypeVoid().parameterCount(1).build()));
            }
        }
        return sendPacketMethod;
    }

    public static MethodAccessor getDisconnectMethod(Class<?> playerConnection) {
        if (disconnectMethod == null) {
            FuzzyReflection playerConnectionClass = FuzzyReflection.fromClass(playerConnection);
            try {
                disconnectMethod = Accessors.getMethodAccessor(playerConnectionClass.getMethod(FuzzyMethodContract.newBuilder().returnTypeVoid().nameRegex("disconnect.*").parameterCount(1).parameterExactType(String.class, 0).build()));
            }
            catch (IllegalArgumentException e) {
                Method disconnect = playerConnectionClass.getMethodByParameters("disconnect", String.class);
                disconnectMethod = Accessors.getMethodAccessor(disconnect);
            }
        }
        return disconnectMethod;
    }

    public static MethodAccessor getNetworkManagerHandleMethod() {
        if (networkManagerHandle == null) {
            Method handleMethod = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass(), true).getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterCount(1).parameterExactType(MinecraftReflection.getPacketClass(), 0).build());
            networkManagerHandle = Accessors.getMethodAccessor(handleMethod);
        }
        return networkManagerHandle;
    }

    public static MethodAccessor getNetworkManagerReadPacketMethod() {
        if (networkManagerPacketRead == null) {
            Method messageReceived = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass(), true).getMethodByParameters("packetRead", ChannelHandlerContext.class, MinecraftReflection.getPacketClass());
            networkManagerPacketRead = Accessors.getMethodAccessor(messageReceived);
        }
        return networkManagerPacketRead;
    }

    public static MethodAccessor getPacketReadByteBufMethod() {
        MinecraftMethods.initializePacket();
        return packetReadByteBuf;
    }

    public static MethodAccessor getPacketWriteByteBufMethod() {
        MinecraftMethods.initializePacket();
        return packetWriteByteBuf;
    }

    private static Constructor<?> setupProxyConstructor() {
        try {
            return ByteBuddyFactory.getInstance().createSubclass(MinecraftReflection.getPacketDataSerializerClass()).name(MinecraftMethods.class.getPackage().getName() + ".PacketDecorator").method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class))).intercept((Implementation)MethodDelegation.to((Object)new Object(){

                @RuntimeType
                public Object delegate(@SuperCall(nullIfImpossible=true) Callable<?> zuper, @Origin Method method) throws Exception {
                    if (method.getName().contains("read")) {
                        throw new ReadMethodException();
                    }
                    if (method.getName().contains("write")) {
                        throw new WriteMethodException();
                    }
                    return zuper.call();
                }
            })).make().load(ByteBuddyFactory.getInstance().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(MinecraftReflection.getByteBufClass());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find constructor!", e);
        }
    }

    private static void initializePacket() {
        if (packetReadByteBuf == null || packetWriteByteBuf == null) {
            if (decoratedDataSerializerAccessor == null) {
                decoratedDataSerializerAccessor = Accessors.getConstructorAccessor(MinecraftMethods.setupProxyConstructor());
            }
            Object serializerBacking = decoratedDataSerializerAccessor.invoke(Unpooled.EMPTY_BUFFER);
            Object decoratedSerializer = decoratedDataSerializerAccessor.invoke(serializerBacking);
            List<Method> candidates = FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethodListByParameters(Void.TYPE, MinecraftReflection.getPacketDataSerializerClass());
            Object dummyPacket = new PacketContainer(PacketType.Play.Client.CLOSE_WINDOW).getHandle();
            for (Method candidate : candidates) {
                try {
                    candidate.invoke(dummyPacket, decoratedSerializer);
                }
                catch (InvocationTargetException exception) {
                    if (exception.getCause() instanceof ReadMethodException) {
                        packetReadByteBuf = Accessors.getMethodAccessor(candidate);
                        continue;
                    }
                    if (!(exception.getCause() instanceof WriteMethodException)) continue;
                    packetWriteByteBuf = Accessors.getMethodAccessor(candidate);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException("Unable to invoke " + candidate, exception);
                }
            }
            if (packetWriteByteBuf == null) {
                throw new IllegalStateException("Unable to find Packet.write(PacketDataSerializer)");
            }
        }
    }

    private static class ReadMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReadMethodException() {
            super("A read method was executed.");
        }
    }

    private static class WriteMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WriteMethodException() {
            super("A write method was executed.");
        }
    }
}

